/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import moze_intel.projecte.PECore;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.ReadOnlyScoreCriteria;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;

public final class PlayerHelper {
    public static final ObjectiveCriteria SCOREBOARD_EMC = new ReadOnlyScoreCriteria("projecte:emc_score");

    public static boolean checkedPlaceBlock(Player player, Level level, BlockPos pos, BlockState state) {
        return PlayerHelper.hasEditPermission(player, level, pos) && PlayerHelper.partiallyCheckedPlaceBlock(player, level, pos, state);
    }

    private static boolean partiallyCheckedPlaceBlock(Player player, Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        SignBlockEntity oldSign = null;
        if (state.getBlock() instanceof SignBlock && (blockEntity = level.getBlockEntity(pos)) instanceof SignBlockEntity) {
            SignBlockEntity sign;
            oldSign = sign = (SignBlockEntity)blockEntity;
        }
        level.captureBlockSnapshots = true;
        level.setBlockAndUpdate(pos, state);
        level.captureBlockSnapshots = false;
        List blockSnapshots = (List)level.capturedBlockSnapshots.clone();
        level.capturedBlockSnapshots.clear();
        boolean eventResult = false;
        if (blockSnapshots.size() > 1) {
            eventResult = ((BlockEvent.EntityMultiPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityMultiPlaceEvent(blockSnapshots, Blocks.AIR.defaultBlockState(), (Entity)player))).isCanceled();
        } else if (blockSnapshots.size() == 1) {
            eventResult = ((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent((BlockSnapshot)blockSnapshots.getFirst(), Blocks.AIR.defaultBlockState(), (Entity)player))).isCanceled();
        }
        if (eventResult) {
            level.restoringBlockSnapshots = true;
            for (BlockSnapshot snapshot : blockSnapshots.reversed()) {
                snapshot.restore(snapshot.getFlags() | 2);
            }
            level.restoringBlockSnapshots = false;
        } else {
            for (BlockSnapshot snap : blockSnapshots) {
                BlockState oldBlock = snap.getState();
                BlockPos snapPos = snap.getPos();
                BlockState newBlock = level.getBlockState(snapPos);
                newBlock.onPlace(level, snapPos, oldBlock, false);
                level.markAndNotifyBlock(snapPos, level.getChunkAt(snapPos), oldBlock, newBlock, snap.getFlags(), 512);
                if (oldSign == null || !snapPos.equals((Object)pos) || !newBlock.hasBlockEntity()) continue;
                WorldHelper.copySignData(level, pos, oldSign);
            }
        }
        level.capturedBlockSnapshots.clear();
        return !eventResult;
    }

    public static boolean checkedReplaceBlock(ServerPlayer player, Level level, BlockPos pos, BlockState state) {
        return PlayerHelper.hasBreakPermission(player, level, pos) && PlayerHelper.partiallyCheckedPlaceBlock((Player)player, level, pos, state);
    }

    public static ItemStack findFirstItem(Player player, Holder<Item> consumeFrom) {
        for (ItemStack s : player.getInventory().items) {
            if (s.isEmpty() || !s.is(consumeFrom)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    public static boolean checkHotbar(Player player, BiPredicate<Player, ItemStack> checker) {
        for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !checker.test(player, stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHotbarCurios(Player player, BiPredicate<Player, ItemStack> checker) {
        if (PlayerHelper.checkHotbar(player, checker)) {
            return true;
        }
        ItemStack offhand = player.getOffhandItem();
        if (!offhand.isEmpty() && checker.test(player, offhand)) {
            return true;
        }
        IItemHandler curios = (IItemHandler)player.getCapability(IntegrationHelper.CURIO_ITEM_HANDLER);
        if (curios != null) {
            int slots = curios.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (stack.isEmpty() || !checker.test(player, stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockHitResult getBlockLookingAt(Player player, double maxDistance) {
        return (BlockHitResult)player.pick(maxDistance, 1.0f, false);
    }

    public static Vec3 getLookTarget(Player player, double maxDistance) {
        Vec3 lookAngle = player.getLookAngle();
        return player.getEyePosition().add(lookAngle.x * maxDistance, lookAngle.y * maxDistance, lookAngle.z * maxDistance);
    }

    public static boolean hasBreakPermission(ServerPlayer player, Level level, BlockPos pos) {
        return PlayerHelper.hasEditPermission((Player)player, level, pos) && PlayerHelper.checkBreakPermission(player, level, pos);
    }

    public static boolean checkBreakPermission(ServerPlayer player, Level level, BlockPos pos) {
        return !CommonHooks.fireBlockBreak((Level)level, (GameType)player.gameMode.getGameModeForPlayer(), (ServerPlayer)player, (BlockPos)pos, (BlockState)level.getBlockState(pos)).isCanceled();
    }

    public static boolean hasEditPermission(Player player, Level level, BlockPos pos) {
        if (!player.mayInteract(level, pos)) {
            return false;
        }
        for (Direction e : Constants.DIRECTIONS) {
            if (player.mayUseItemAt(pos, e, ItemStack.EMPTY)) continue;
            return false;
        }
        return true;
    }

    public static void resetCooldown(Player player) {
        player.resetAttackStrengthTicker();
        PECore.packetHandler().resetCooldown((ServerPlayer)player);
    }

    public static void swingItem(Player player, InteractionHand hand) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int action = hand == InteractionHand.MAIN_HAND ? 0 : 3;
            level2.getChunkSource().broadcastAndSend((Entity)player, (Packet)new ClientboundAnimatePacket((Entity)player, action));
        }
    }

    public static void updateScore(ServerPlayer player, ObjectiveCriteria objective, BigInteger value) {
        PlayerHelper.updateScore(player, objective, MathUtils.clampToInt(value));
    }

    public static void updateScore(ServerPlayer player, ObjectiveCriteria objective, int value) {
        player.getScoreboard().forAllObjectives(objective, (ScoreHolder)player, score -> score.set(value));
    }

    public static boolean checkFeedCooldown(Player player) {
        return player.getFoodData().needsFood() && PlayerHelper.checkCooldown(player, (Item)PEItems.BODY_STONE.get(), ProjectEConfig.server.cooldown.player.feed);
    }

    public static boolean checkHealCooldown(Player player) {
        return player.getHealth() < player.getMaxHealth() && PlayerHelper.checkCooldown(player, (Item)PEItems.SOUL_STONE.get(), ProjectEConfig.server.cooldown.player.heal);
    }

    public static boolean checkCooldown(Player player, Item item, IntSupplier cooldownSupplier) {
        ItemCooldowns cooldowns = player.getCooldowns();
        if (cooldowns.isOnCooldown(item)) {
            return false;
        }
        int cooldown = cooldownSupplier.getAsInt();
        if (cooldown == -1) {
            return false;
        }
        if (cooldown > 0) {
            cooldowns.addCooldown(item, cooldown);
        }
        return true;
    }
}

