/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils.text;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SearchQueryParser {
    private static final Set<Character> TERMINATORS = Set.of(Character.valueOf('|'), Character.valueOf('('), Character.valueOf('\"'), Character.valueOf('\''));

    public static ISearchQuery parse(String query) {
        if (query == null || query.isEmpty()) {
            return ISearchQuery.INVALID;
        }
        SearchQuery curQuery = new SearchQuery();
        HashSet<SearchQuery> ret = null;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '|') {
                if (!curQuery.isEmpty()) {
                    if (ret == null) {
                        ret = new HashSet<SearchQuery>();
                    }
                    ret.add(curQuery);
                }
                curQuery = new SearchQuery();
                continue;
            }
            if (c == ' ') continue;
            QueryType type = QueryType.get(c);
            if (type != null) {
                ++i;
            } else {
                type = QueryType.NAME;
            }
            KeyListResult keyListResult = SearchQueryParser.readKeyList(query, i, type, curQuery);
            if (!keyListResult.hasResult()) {
                return ISearchQuery.INVALID;
            }
            i = keyListResult.index();
        }
        if (!curQuery.isEmpty()) {
            if (ret == null) {
                return curQuery;
            }
            ret.add(curQuery);
        }
        return ret == null ? ISearchQuery.INVALID : new SearchQuerySet((Set<SearchQuery>)ret);
    }

    private static KeyListResult readKeyList(String query, int start, QueryType type, SearchQuery curQuery) {
        int newIndex;
        List<String> keys;
        if (start >= query.length()) {
            return new KeyListResult(true, start);
        }
        char qc = query.charAt(start);
        if (qc == '(') {
            ListResult<String> listResult = SearchQueryParser.readList(query, start);
            if (listResult == null) {
                return KeyListResult.INVALID;
            }
            keys = listResult.result();
            newIndex = listResult.index();
        } else if (qc == '\"' || qc == '\'') {
            Result quoteResult = SearchQueryParser.readQuote(query, start);
            if (quoteResult == null) {
                return KeyListResult.INVALID;
            }
            keys = Collections.singletonList(quoteResult.result());
            newIndex = quoteResult.index();
        } else {
            Result textResult = SearchQueryParser.readUntilTermination(query, start, type != QueryType.NAME);
            keys = Collections.singletonList(textResult.result());
            newIndex = textResult.index();
        }
        if (!keys.isEmpty()) {
            curQuery.queryStrings.put(type, keys);
        }
        return new KeyListResult(true, newIndex);
    }

    @Nullable
    private static ListResult<String> readList(String query, int start) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        block5: for (int i = start + 1; i < query.length(); ++i) {
            char qc = query.charAt(i);
            switch (qc) {
                case ')': {
                    String key = sb.toString().trim();
                    if (!key.isEmpty()) {
                        ret.add(key);
                    }
                    return new ListResult<String>(ret, i);
                }
                case '|': {
                    String key = sb.toString().trim();
                    if (!key.isEmpty()) {
                        ret.add(key);
                    }
                    sb = new StringBuilder();
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    Result quoteResult = SearchQueryParser.readQuote(query, i);
                    if (quoteResult == null) {
                        return null;
                    }
                    ret.add(quoteResult.result());
                    i = quoteResult.index();
                    continue block5;
                }
                default: {
                    sb.append(qc);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Result readQuote(String text, int start) {
        char quoteChar = text.charAt(start);
        StringBuilder ret = new StringBuilder();
        for (int i = start + 1; i < text.length(); ++i) {
            char tc = text.charAt(i);
            if (tc == quoteChar) {
                return new Result(ret.toString(), i);
            }
            ret.append(tc);
        }
        return null;
    }

    private static Result readUntilTermination(String text, int start, boolean spaceTerminate) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = start; i < text.length(); ++i) {
            char tc = text.charAt(i);
            if (TERMINATORS.contains(Character.valueOf(tc)) || QueryType.get(tc) != null || spaceTerminate && tc == ' ') {
                --i;
                break;
            }
            sb.append(tc);
        }
        return new Result(sb.toString().trim(), i);
    }

    @FunctionalInterface
    public static interface ISearchQuery {
        public static final ISearchQuery INVALID = (level, player, stack) -> false;

        public boolean test(@Nullable Level var1, @Nullable Player var2, ItemStack var3);

        default public boolean isInvalid() {
            return this == INVALID;
        }
    }

    public static class SearchQuery
    implements ISearchQuery {
        private final Map<QueryType, List<String>> queryStrings = new EnumMap<QueryType, List<String>>(QueryType.class);

        @Override
        public boolean test(@Nullable Level level, @Nullable Player player, ItemStack stack) {
            for (Map.Entry<QueryType, List<String>> entry : this.queryStrings.entrySet()) {
                boolean hasNoMatch = true;
                for (String key : entry.getValue()) {
                    if (!entry.getKey().matches(level, player, key, stack)) continue;
                    hasNoMatch = false;
                    break;
                }
                if (!hasNoMatch) continue;
                return false;
            }
            return true;
        }

        private boolean isEmpty() {
            return this.queryStrings.isEmpty();
        }

        protected Map<QueryType, List<String>> getQueryMap() {
            return this.queryStrings;
        }

        public String toString() {
            return this.queryStrings.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.queryStrings.equals(((SearchQuery)o).queryStrings);
        }

        public int hashCode() {
            return this.queryStrings.hashCode();
        }
    }

    public static enum QueryType {
        NAME('~'){

            @Override
            public boolean matches(@Nullable Level level, @Nullable Player player, String key, ItemStack stack) {
                return stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains(key);
            }
        }
        ,
        MOD_ID('@'){

            @Override
            public boolean matches(@Nullable Level level, @Nullable Player player, String key, ItemStack stack) {
                Item item = stack.getItem();
                String modid = item.getCreatorModId(stack);
                if (modid == null) {
                    PECore.LOGGER.error("Unexpected null registry name for item of class type: {}", (Object)item.getClass().getSimpleName());
                    return false;
                }
                return modid.toLowerCase(Locale.ROOT).contains(key);
            }
        }
        ,
        TOOLTIP('$'){

            @Override
            public boolean matches(@Nullable Level level, @Nullable Player player, String key, ItemStack stack) {
                for (Component tooltipLine : stack.getTooltipLines(Item.TooltipContext.of((Level)level), player, (TooltipFlag)TooltipFlag.Default.NORMAL)) {
                    String tooltip = tooltipLine.getString().toLowerCase(Locale.ROOT);
                    if (!tooltip.contains(key)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        TAG('#'){

            @Override
            public boolean matches(@Nullable Level level, @Nullable Player player, String key, ItemStack stack) {
                return stack.getTags().anyMatch(tag -> tag.location().toString().toLowerCase(Locale.ROOT).contains(key));
            }
        };

        private static final Char2ObjectMap<QueryType> charLookupMap;
        private final char prefix;

        public static QueryType get(char prefix) {
            return (QueryType)((Object)charLookupMap.get(prefix));
        }

        public static CharSet getPrefixChars() {
            return charLookupMap.keySet();
        }

        private QueryType(char prefix) {
            this.prefix = prefix;
        }

        public abstract boolean matches(@Nullable Level var1, @Nullable Player var2, String var3, ItemStack var4);

        static {
            QueryType[] values = QueryType.values();
            charLookupMap = new Char2ObjectArrayMap(values.length);
            for (QueryType type : values) {
                charLookupMap.put(type.prefix, (Object)type);
            }
        }
    }

    private record KeyListResult(boolean hasResult, int index) {
        public static final KeyListResult INVALID = new KeyListResult(false, -1);
    }

    public static class SearchQuerySet
    implements ISearchQuery {
        private final Set<SearchQuery> queries;

        private SearchQuerySet(Set<SearchQuery> queries) {
            this.queries = queries;
        }

        @Override
        public boolean test(@Nullable Level level, @Nullable Player player, ItemStack stack) {
            if (this.queries.isEmpty()) {
                return true;
            }
            for (SearchQuery query : this.queries) {
                if (!query.test(level, player, stack)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.queries.toString();
        }

        protected Set<SearchQuery> getQueries() {
            return this.queries;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.queries.equals(((SearchQuerySet)o).queries);
        }

        public int hashCode() {
            return this.queries.hashCode();
        }
    }

    private record ListResult<TYPE>(List<TYPE> result, int index) {
    }

    private record Result(String result, int index) {
    }
}

