/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.world_transmutation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.function.Function;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutationFunction;
import moze_intel.projecte.api.world_transmutation.SimpleWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.WorldTransmutation;
import moze_intel.projecte.api.world_transmutation.WorldTransmutationFile;
import moze_intel.projecte.network.packets.to_client.SyncWorldTransmutations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTransmutationManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final WorldTransmutationManager INSTANCE = new WorldTransmutationManager();
    private static final Function<Block, SequencedSet<IWorldTransmutation>> SET_BUILDER = origin -> new LinkedHashSet(1);
    private Reference2ObjectMap<Block, SequencedSet<IWorldTransmutation>> entries = Reference2ObjectMaps.emptyMap();
    @Nullable
    private Reference2ObjectMap<Block, SequencedSet<IWorldTransmutation>> modifiedEntries = null;

    private WorldTransmutationManager() {
        super(GSON, "pe_world_transmutations");
    }

    public static SyncWorldTransmutations getSyncPacket() {
        return new SyncWorldTransmutations(INSTANCE.getWorldTransmutations());
    }

    @ApiStatus.Internal
    public void setEntries(Reference2ObjectMap<Block, SequencedSet<IWorldTransmutation>> transmutations) {
        this.entries = transmutations;
        this.modifiedEntries = null;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ConditionalOps registryOps = this.makeConditionalOps();
        Reference2ObjectLinkedOpenHashMap builder = new Reference2ObjectLinkedOpenHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation file = entry.getKey();
            DataResult result = WorldTransmutationFile.CONDITIONAL_CODEC.parse((DynamicOps)registryOps, (Object)entry.getValue());
            if (result.isSuccess()) {
                Optional decoded = (Optional)result.getOrThrow();
                if (decoded.isPresent()) {
                    for (IWorldTransmutation transmutation : ((WorldTransmutationFile)((WithConditions)decoded.get()).carrier()).transmutations()) {
                        SequencedSet transmutations = (SequencedSet)builder.computeIfAbsent((Object)((Block)transmutation.origin().value()), SET_BUILDER);
                        if (transmutations.add(transmutation)) {
                            PECore.debugLog("World Transmutation File: '{}' registered {}", file, transmutation);
                            continue;
                        }
                        PECore.debugLog("World Transmutation File: '{}' registered {}. Skipped as it was identical to an already registered transmutation", file, transmutation);
                    }
                    continue;
                }
                PECore.debugLog("Skipping loading world transmutation file {} as its conditions were not met", file);
                continue;
            }
            result.ifError(error -> PECore.LOGGER.error("Parsing error loading world transmutation file {}: {}", (Object)file, (Object)error.message()));
        }
        ObjectIterator iterator = Reference2ObjectMaps.fastIterator((Reference2ObjectMap)builder);
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            int elements = ((SequencedSet)entry.getValue()).size();
            if (elements == 0) {
                iterator.remove();
                continue;
            }
            if (elements <= 1) continue;
            LinkedHashSet<IWorldTransmutation> setBuilder = new LinkedHashSet<IWorldTransmutation>(elements);
            boolean hasSimple = false;
            boolean hasComplex = false;
            for (IWorldTransmutation transmutation : (SequencedSet)entry.getValue()) {
                if (transmutation instanceof WorldTransmutation) {
                    hasComplex = true;
                    setBuilder.add(transmutation);
                    continue;
                }
                hasSimple = true;
            }
            if (!hasSimple || !hasComplex) continue;
            for (IWorldTransmutation transmutation : (SequencedSet)entry.getValue()) {
                if (!(transmutation instanceof SimpleWorldTransmutation)) continue;
                setBuilder.add(transmutation);
            }
            entry.setValue(setBuilder);
        }
        this.setEntries((Reference2ObjectMap<Block, SequencedSet<IWorldTransmutation>>)builder);
    }

    public Reference2ObjectMap<Block, SequencedSet<IWorldTransmutation>> getWorldTransmutations() {
        return this.modifiedEntries == null ? this.entries : this.modifiedEntries;
    }

    @Nullable
    public IWorldTransmutationFunction getWorldTransmutation(BlockState current) {
        return this.getWorldTransmutation(current, false);
    }

    @Nullable
    public IWorldTransmutationFunction getWorldTransmutation(BlockState current, boolean findAny) {
        if (current.isAir()) {
            return null;
        }
        SequencedSet transmutations = (SequencedSet)this.getWorldTransmutations().getOrDefault((Object)current.getBlock(), Collections.emptySortedSet());
        boolean hasComplex = false;
        for (IWorldTransmutation entry : transmutations) {
            if (entry.canTransmute(current)) {
                if (findAny) {
                    return entry;
                }
                if (hasComplex && entry instanceof SimpleWorldTransmutation) {
                    IWorldTransmutation transmutation;
                    Reference2ObjectOpenHashMap exactStates = new Reference2ObjectOpenHashMap();
                    Iterator iterator = transmutations.iterator();
                    while (iterator.hasNext() && (transmutation = (IWorldTransmutation)iterator.next()) instanceof WorldTransmutation) {
                        WorldTransmutation worldTransmutation = (WorldTransmutation)transmutation;
                        exactStates.putIfAbsent(worldTransmutation.originState(), transmutation);
                    }
                    return (arg_0, arg_1) -> WorldTransmutationManager.lambda$getWorldTransmutation$2((Map)exactStates, entry, arg_0, arg_1);
                }
                return entry;
            }
            if (!(entry instanceof WorldTransmutation)) continue;
            hasComplex = true;
        }
        return null;
    }

    @ApiStatus.Internal
    public void clearTransmutations() {
        this.modifiedEntries = Reference2ObjectMaps.emptyMap();
    }

    @ApiStatus.Internal
    public void resetWorldTransmutations() {
        this.modifiedEntries = null;
    }

    @ApiStatus.Internal
    public void register(IWorldTransmutation transmutation) {
        if (this.modifiedEntries == null) {
            this.makeEntriesMutable();
        } else if (this.modifiedEntries == Reference2ObjectMaps.emptyMap()) {
            this.modifiedEntries = new Reference2ObjectLinkedOpenHashMap();
        }
        ((SequencedSet)this.modifiedEntries.computeIfAbsent((Object)((Block)transmutation.origin().value()), origin -> new LinkedHashSet())).add(transmutation);
    }

    @ApiStatus.Internal
    public void removeWorldTransmutation(IWorldTransmutation transmutation) {
        SequencedSet transmutations;
        boolean remove;
        Block origin = (Block)transmutation.origin().value();
        boolean bl = remove = this.modifiedEntries != null;
        if (!remove && (transmutations = (SequencedSet)this.entries.get((Object)origin)) != null && transmutations.contains(transmutation)) {
            this.makeEntriesMutable();
            remove = true;
        }
        if (remove && (transmutations = (SequencedSet)this.modifiedEntries.get((Object)origin)) != null && transmutations.remove(transmutation) && transmutations.isEmpty()) {
            this.modifiedEntries.remove((Object)origin);
            if (this.modifiedEntries.isEmpty()) {
                this.modifiedEntries = Reference2ObjectMaps.emptyMap();
            }
        }
    }

    private void makeEntriesMutable() {
        this.modifiedEntries = new Reference2ObjectLinkedOpenHashMap(this.entries.size());
        for (Map.Entry entry : this.entries.entrySet()) {
            this.modifiedEntries.put((Object)((Block)entry.getKey()), new LinkedHashSet((Collection)entry.getValue()));
        }
    }

    private static /* synthetic */ BlockState lambda$getWorldTransmutation$2(Map exactStates, IWorldTransmutation entry, BlockState input, boolean isSneaking) {
        return Objects.requireNonNullElse((IWorldTransmutation)exactStates.get(input), entry).result(input, isSneaking);
    }
}

