/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.helper.SharingHelper;
import vazkii.psi.client.gui.button.GuiButtonHelp;
import vazkii.psi.client.gui.button.GuiButtonIO;
import vazkii.psi.client.gui.button.GuiButtonSideConfig;
import vazkii.psi.client.gui.widget.CallbackTextFieldWidget;
import vazkii.psi.client.gui.widget.PiecePanelWidget;
import vazkii.psi.client.gui.widget.SideConfigWidget;
import vazkii.psi.client.gui.widget.SpellCostsWidget;
import vazkii.psi.client.gui.widget.StatusWidget;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageSpellModified;
import vazkii.psi.common.spell.SpellCompiler;
import vazkii.psi.common.spell.other.PieceConnector;

@OnlyIn(value=Dist.CLIENT)
public class GuiProgrammer
extends Screen {
    public static final ResourceLocation texture = ResourceLocation.parse((String)"psi:textures/gui/programmer.png");
    public static final RenderType LAYER;
    public static SpellPiece clipboard;
    public static int selectedX;
    public static int selectedY;
    public final TileProgrammer programmer;
    public final Stack<Spell> undoSteps = new Stack();
    public final Stack<Spell> redoSteps = new Stack();
    public Spell spell;
    public List<Component> tooltip = new ArrayList<Component>();
    public Either<CompiledSpell, SpellCompilationException> compileResult;
    public int xSize;
    public int ySize;
    public int padLeft;
    public int padTop;
    public int left;
    public int top;
    public int gridLeft;
    public int gridTop;
    public int cursorX;
    public int cursorY;
    public boolean commentEnabled;
    public GuiButtonHelp helpButton;
    public EditBox spellNameField;
    public EditBox commentField;
    public PiecePanelWidget panelWidget;
    public SideConfigWidget configWidget;
    public SpellCostsWidget spellCostsWidget;
    public StatusWidget statusWidget;
    public TooltipFlag tooltipFlag;
    public boolean mouseMoved = false;
    public boolean takingScreenshot = false;
    public boolean shareToReddit = false;
    boolean spectator;

    public GuiProgrammer(TileProgrammer programmer) {
        this(programmer, programmer.spell);
    }

    public GuiProgrammer(TileProgrammer tile, Spell spell) {
        super((Component)Component.empty());
        this.programmer = tile;
        this.spell = spell;
        this.compileResult = new SpellCompiler().compile(spell);
    }

    public static String convertIntToLetter(int i) {
        if (!((Boolean)ConfigHandler.CLIENT.changeGridCoordinatesToLetterNumber.get()).booleanValue()) {
            return String.valueOf(i);
        }
        return String.valueOf((char)(i % 27 + 64));
    }

    public void mouseMoved(double xPos, double mouseY) {
        this.mouseMoved = true;
    }

    protected void init() {
        this.xSize = 174;
        this.ySize = 184;
        this.padLeft = 7;
        this.padTop = 7;
        this.left = (this.width - this.xSize) / 2;
        this.top = (this.height - this.ySize) / 2;
        this.gridLeft = this.left + this.padLeft;
        this.gridTop = this.top + this.padTop;
        this.cursorY = -1;
        this.cursorX = -1;
        TooltipFlag.Default default_ = this.tooltipFlag = this.getMinecraft().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        this.spectator = this.programmer == null ? false : !this.programmer.playerLock.isEmpty() && this.getMinecraft().player != null && !this.programmer.playerLock.equals(this.getMinecraft().player.getName().getString());
        this.statusWidget = (StatusWidget)this.addRenderableWidget((GuiEventListener)new StatusWidget(this.left - 48, this.top + 5, 48, 30, "", this));
        this.spellCostsWidget = (SpellCostsWidget)this.addRenderableWidget((GuiEventListener)new SpellCostsWidget(this.left + this.xSize + 3, this.top + (this.takingScreenshot ? 40 : 20), 100, 126, "", this));
        this.panelWidget = (PiecePanelWidget)this.addRenderableWidget(new PiecePanelWidget(0, 0, 100, 125, "", this));
        this.helpButton = (GuiButtonHelp)this.addRenderableWidget((GuiEventListener)new GuiButtonHelp(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 32 : 48), this));
        this.configWidget = (SideConfigWidget)this.addRenderableWidget((GuiEventListener)new SideConfigWidget(this.left - 81, this.top + 55, 81, 115, this));
        this.spellNameField = (EditBox)this.addRenderableWidget((GuiEventListener)new CallbackTextFieldWidget(this.getMinecraft().font, this.left + this.xSize - 130, this.top + this.ySize - 14, 120, 10, button -> {
            this.spell.name = this.spellNameField.getValue();
            this.onSpellChanged(true);
        }));
        this.spellNameField.setBordered(false);
        this.spellNameField.setMaxLength(20);
        this.spellNameField.setEditable(!this.spectator);
        this.commentField = (EditBox)this.addRenderableWidget((GuiEventListener)new CallbackTextFieldWidget(this.getMinecraft().font, this.left, this.top + this.ySize / 2 - 10, this.xSize, 20, button -> {}));
        this.commentField.setEditable(false);
        this.commentField.setVisible(false);
        this.commentField.setMaxLength(500);
        this.panelWidget.searchField = (EditBox)this.addRenderableWidget((GuiEventListener)new CallbackTextFieldWidget(this.getMinecraft().font, 0, 0, 70, 10, button -> {
            this.panelWidget.page = 0;
            this.panelWidget.updatePanelButtons();
        }));
        this.panelWidget.searchField.setEditable(false);
        this.panelWidget.searchField.setVisible(false);
        this.panelWidget.searchField.setBordered(false);
        if (this.spell == null) {
            this.spell = new Spell();
        }
        if (this.programmer != null && this.programmer.spell == null) {
            this.programmer.spell = this.spell;
        }
        this.spellNameField.setValue(this.spell.name);
        this.panelWidget.populatePanelButtons();
        this.onSelectedChanged();
        this.addRenderableWidget((GuiEventListener)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 16 : 32), true, this, button -> {
            if (GuiProgrammer.hasShiftDown()) {
                CompoundTag cmp = new CompoundTag();
                if (this.spell != null) {
                    this.spell.writeToNBT(cmp);
                }
                this.getMinecraft().keyboardHandler.setClipboard(cmp.toString());
            }
        }));
        if (!this.spectator) {
            this.addRenderableWidget((GuiEventListener)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - 16, false, this, button -> {
                if (GuiProgrammer.hasShiftDown()) {
                    String cb = this.getMinecraft().keyboardHandler.getClipboard();
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player == null) {
                        return;
                    }
                    try {
                        cb = cb.replaceAll("([^a-z0-9])\\d+:", "$1");
                        CompoundTag cmp = TagParser.parseTag((String)cb);
                        if (cmp.contains("modsRequired")) {
                            ListTag mods = (ListTag)cmp.get("modsRequired");
                            if (mods == null) {
                                return;
                            }
                            for (Tag mod : mods) {
                                String modName = ((CompoundTag)mod).getString("modName");
                                if (!PsiAPI.SPELL_PIECE_REGISTRY.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet()).contains(modName)) {
                                    player.sendSystemMessage((Component)Component.translatable((String)"psimisc.modnotfound", (Object[])new Object[]{modName}).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                                }
                                if (!modName.equals("psi")) continue;
                                boolean sendMessage = false;
                                String modVersion = ((CompoundTag)mod).getString("modVersion");
                                int[] versionEntry = Arrays.stream(modVersion.replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                int[] currentVersion = Arrays.stream(((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString().replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                for (int i = 0; i < versionEntry.length && versionEntry.length == currentVersion.length; ++i) {
                                    if (i + 1 > currentVersion.length) {
                                        sendMessage = true;
                                        break;
                                    }
                                    if (currentVersion[i] > versionEntry[i]) break;
                                    if (currentVersion[i] >= versionEntry[i]) continue;
                                    sendMessage = true;
                                    break;
                                }
                                if (!sendMessage) continue;
                                player.sendSystemMessage((Component)Component.translatable((String)"psimisc.spellonnewerversion").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                            }
                        } else {
                            player.sendSystemMessage((Component)Component.translatable((String)"psimisc.spellmaynotfunctionasintended").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                        }
                        this.spell = Spell.createFromNBT(cmp);
                        if (this.spell == null) {
                            return;
                        }
                        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)player);
                        for (int i = 0; i < 9; ++i) {
                            for (int j = 0; j < 9; ++j) {
                                Optional<Map.Entry> advancementEntry;
                                SpellPiece piece = this.spell.grid.gridData[i][j];
                                if (piece == null || (advancementEntry = PsiAPI.ADVANCEMENT_GROUP_REGISTRY.entrySet().stream().filter(entry -> ((Collection)entry.getValue()).contains(piece.getClass())).findFirst()).isEmpty() || player.isCreative() || data.isPieceGroupUnlocked(((ResourceKey)advancementEntry.get().getKey()).location(), piece.registryKey)) continue;
                                player.sendSystemMessage((Component)Component.translatable((String)"psimisc.missing_pieces").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                                return;
                            }
                        }
                        this.pushState(true);
                        this.spellNameField.setValue(this.spell.name);
                        this.onSpellChanged(false);
                    }
                    catch (Exception t) {
                        player.sendSystemMessage((Component)Component.translatable((String)"psimisc.malformed_json", (Object[])new Object[]{t.getMessage()}).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                        Psi.logger.error("Error importing spell from clipboard", (Throwable)t);
                    }
                }
            }));
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!(this.programmer == null || this.programmer.getLevel() == null || this.getMinecraft().player == null || this.programmer.getLevel().getBlockEntity(this.programmer.getBlockPos()) == this.programmer && this.programmer.canPlayerInteract((Player)this.getMinecraft().player))) {
            this.getMinecraft().setScreen(null);
            return;
        }
        String comment = "";
        int color = Psi.magical ? 0 : 0xFFFFFF;
        graphics.pose().pushPose();
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(texture, this.left, this.top, 0, 0, this.xSize, this.ySize);
        SpellPiece piece = null;
        if (SpellGrid.exists(selectedX, selectedY)) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        this.cursorX = (mouseX - this.gridLeft) / 18;
        this.cursorY = (mouseY - this.gridTop) / 18;
        if (this.panelWidget.panelEnabled || this.cursorX > 8 || this.cursorY > 8 || this.cursorX < 0 || this.cursorY < 0 || mouseX < this.gridLeft || mouseY < this.gridTop) {
            this.cursorX = -1;
            this.cursorY = -1;
        }
        graphics.pose().pushPose();
        this.tooltip.clear();
        graphics.pose().translate((float)this.gridLeft, (float)this.gridTop, 0.0f);
        MultiBufferSource.BufferSource buffers = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        this.spell.draw(graphics.pose(), (MultiBufferSource)buffers, 0xF000F0);
        buffers.endBatch();
        this.compileResult.right().ifPresent(ex -> {
            Pair<Integer, Integer> errorPos = ex.location;
            if (errorPos != null && (Integer)errorPos.getRight() != -1 && (Integer)errorPos.getLeft() != -1) {
                graphics.drawString(this.getMinecraft().font, "!!", (Integer)errorPos.getLeft() * 18 + 12, (Integer)errorPos.getRight() * 18 + 8, 0xFF0000, true);
            }
        });
        graphics.pose().popPose();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.pose().translate(0.0f, 0.0f, 1.0f);
        if (selectedX != -1 && selectedY != -1 && !this.takingScreenshot) {
            graphics.blit(texture, this.gridLeft + selectedX * 18, this.gridTop + selectedY * 18, 32, this.ySize, 16, 16);
        }
        if (GuiProgrammer.hasAltDown()) {
            this.tooltip.clear();
            this.cursorX = selectedX;
            this.cursorY = selectedY;
            mouseX = this.gridLeft + this.cursorX * 18 + 10;
            mouseY = this.gridTop + this.cursorY * 18 + 8;
        }
        if (this.takingScreenshot) {
            Set addons = this.spell.getPieceNamespaces().stream().filter(namespace -> !namespace.equals("psi")).collect(Collectors.toSet());
            if (!addons.isEmpty()) {
                String requiredAddons = String.valueOf(ChatFormatting.GREEN) + "Required Addons:";
                graphics.drawString(this.getMinecraft().font, requiredAddons, this.left - this.font.width(requiredAddons) - 5, this.top + 40, 0xFFFFFF, true);
                int i = 1;
                for (String addon : addons) {
                    if (!ModList.get().getModContainerById(addon).isPresent()) continue;
                    String modName = ((ModContainer)ModList.get().getModContainerById(addon).get()).getModInfo().getDisplayName();
                    graphics.drawString(this.getMinecraft().font, "* " + modName, this.left - this.font.width(requiredAddons) - 5, this.top + 40 + 10 * i, 0xFFFFFF, true);
                    ++i;
                }
            }
            String version = "Psi " + ((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString();
            graphics.drawString(this.getMinecraft().font, version, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.width(version) / 2.0f, (float)this.top - 22.0f, 0xFFFFFF, true);
        }
        SpellPiece pieceAtCursor = null;
        if (this.cursorX != -1 && this.cursorY != -1) {
            pieceAtCursor = this.spell.grid.gridData[this.cursorX][this.cursorY];
            if (pieceAtCursor != null) {
                pieceAtCursor.getTooltip(this.tooltip);
                comment = pieceAtCursor.comment;
            }
            if (!this.takingScreenshot) {
                if (this.cursorX == selectedX && this.cursorY == selectedY) {
                    graphics.blit(texture, this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 8, 16);
                } else {
                    graphics.blit(texture, this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 16, 16);
                }
            }
        }
        int topY = this.top - 22;
        if (!this.takingScreenshot) {
            int topYText = topY;
            if (this.spectator) {
                String spectator = String.valueOf(ChatFormatting.RED) + I18n.get((String)"psimisc.spectator", (Object[])new Object[0]);
                graphics.drawString(this.getMinecraft().font, spectator, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.width(spectator) / 2.0f, (float)topYText, 0xFFFFFF, true);
                topYText -= 10;
            }
            if (piece != null) {
                String pieceName = I18n.get((String)piece.getUnlocalizedName(), (Object[])new Object[0]);
                graphics.drawString(this.getMinecraft().font, pieceName, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.width(pieceName) / 2.0f, (float)topYText, 0xFFFFFF, true);
            }
            String coords = SpellGrid.exists(this.cursorX, this.cursorY) ? I18n.get((String)"psimisc.programmer_coords", (Object[])new Object[]{GuiProgrammer.convertIntToLetter(selectedX + 1), selectedY + 1, GuiProgrammer.convertIntToLetter(this.cursorX + 1), this.cursorY + 1}) : I18n.get((String)"psimisc.programmer_coords_no_cursor", (Object[])new Object[]{GuiProgrammer.convertIntToLetter(selectedX + 1), selectedY + 1});
            graphics.drawString(this.getMinecraft().font, coords, this.left + 4, topY + this.ySize + 24, 0x44FFFFFF);
            String version = "Psi " + ((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString();
            graphics.drawString(this.getMinecraft().font, version, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.width(version) / 2.0f, (float)(topY + this.ySize + 24 + this.font.wordWrapHeight(coords, this.font.width(coords)) + 5), 0x44FFFFFF, true);
        }
        if (Psi.magical) {
            graphics.drawString(this.getMinecraft().font, I18n.get((String)"psimisc.name", (Object[])new Object[0]), this.left + this.padLeft, this.spellNameField.getY() + 1, color);
        } else {
            graphics.drawString(this.getMinecraft().font, I18n.get((String)"psimisc.name", (Object[])new Object[0]), this.left + this.padLeft, this.spellNameField.getY() + 1, color, true);
        }
        if (this.commentEnabled) {
            String enterCommit = I18n.get((String)"psimisc.enter_commit", (Object[])new Object[0]);
            graphics.drawString(this.getMinecraft().font, enterCommit, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.width(enterCommit) / 2.0f, (float)(this.commentField.getY() + 24), 0xFFFFFF, true);
            String semicolonLine = I18n.get((String)"psimisc.semicolon_line", (Object[])new Object[0]);
            graphics.drawString(this.getMinecraft().font, semicolonLine, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.width(semicolonLine) / 2.0f, (float)(this.commentField.getY() + 34), 0xFFFFFF, true);
        }
        ArrayList<Component> legitTooltip = null;
        if (GuiProgrammer.hasAltDown()) {
            legitTooltip = new ArrayList<Component>(this.tooltip);
        }
        if (GuiProgrammer.hasAltDown()) {
            this.tooltip = legitTooltip;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (!this.takingScreenshot && this.tooltip != null && !this.tooltip.isEmpty() && pieceAtCursor == null && this.mouseMoved) {
            graphics.renderTooltip(this.getMinecraft().font, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (!this.takingScreenshot && pieceAtCursor != null && this.mouseMoved) {
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                pieceAtCursor.drawTooltip(graphics, mouseX, mouseY, this.tooltip, this);
            }
            if (comment != null && !comment.isEmpty()) {
                List<Component> commentList = Arrays.stream(comment.split(";")).map(Component::literal).collect(Collectors.toList());
                pieceAtCursor.drawCommentText(graphics, mouseX, mouseY, commentList, this);
            }
        }
        graphics.pose().popPose();
        if (this.takingScreenshot) {
            String name = this.spell.name;
            String export = Spell.CODEC.encode((Object)this.spell, (DynamicOps)JsonOps.INSTANCE, JsonOps.INSTANCE.mapBuilder()).toString();
            if (this.shareToReddit) {
                SharingHelper.uploadAndShare(name, export);
            } else {
                SharingHelper.uploadAndOpen(name, export);
            }
            this.takingScreenshot = false;
            this.shareToReddit = false;
        }
    }

    public void addButtons(List<Button> list) {
        list.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void pushState(boolean wipeRedo) {
        if (wipeRedo) {
            this.redoSteps.clear();
        }
        this.undoSteps.push(this.spell.copy());
        if (this.undoSteps.size() > 25) {
            this.undoSteps.removeFirst();
        }
    }

    public void onSpellChanged(boolean nameOnly) {
        if (this.programmer != null) {
            if (!this.spectator) {
                MessageSpellModified message = new MessageSpellModified(this.programmer.getBlockPos(), this.spell);
                MessageRegister.sendToServer(message);
            }
            this.programmer.spell = this.spell;
            this.programmer.onSpellChanged();
        }
        this.onSelectedChanged();
        if (!nameOnly || this.compileResult.right().filter(ex -> ex.getMessage().equals("psi.spellerror.noname")).isPresent() || this.spell.name.isEmpty()) {
            this.compileResult = new SpellCompiler().compile(this.spell);
        }
    }

    public void onSelectedChanged() {
        SpellPiece piece;
        this.renderables.removeAll(this.configWidget.configButtons);
        this.children().removeAll(this.configWidget.configButtons);
        this.configWidget.configButtons.clear();
        this.spellNameField.setEditable(!this.spectator);
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null) {
            boolean intercept = piece.interceptKeystrokes();
            this.spellNameField.setEditable(!this.spectator && !intercept);
            if (piece.hasConfig()) {
                int i = 0;
                for (String paramName : piece.params.keySet()) {
                    SpellParam<?> param = piece.params.get(paramName);
                    int x = this.left - 17;
                    int y = this.top + 70 + i * 26;
                    for (SpellParam.Side side : ImmutableSet.of((Object)((Object)SpellParam.Side.TOP), (Object)((Object)SpellParam.Side.BOTTOM), (Object)((Object)SpellParam.Side.LEFT), (Object)((Object)SpellParam.Side.RIGHT), (Object)((Object)SpellParam.Side.OFF))) {
                        if (!side.isEnabled() && !param.canDisable) continue;
                        int xp = x + side.offx * 8;
                        int yp = y + side.offy * 8;
                        this.configWidget.configButtons.add(new GuiButtonSideConfig(this, selectedX, selectedY, i, paramName, side, xp, yp, button -> {
                            if (!this.spectator) {
                                this.pushState(true);
                                GuiButtonSideConfig.performAction(this, selectedX, selectedY, paramName, side);
                                this.onSpellChanged(false);
                            }
                        }));
                    }
                    ++i;
                }
                this.configWidget.configButtons.forEach(x$0 -> {
                    Button cfr_ignored_0 = (Button)this.addRenderableWidget((GuiEventListener)x$0);
                });
                this.configWidget.configEnabled = true;
                return;
            }
        }
        this.configWidget.configEnabled = false;
    }

    public boolean charTyped(char character, int keyCode) {
        SpellPiece piece;
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (this.spectator) {
            return false;
        }
        super.charTyped(character, keyCode);
        if (!this.commentEnabled && !this.spellNameField.isFocused() && selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onCharTyped(character, keyCode, false)) {
            this.pushState(true);
            piece.onCharTyped(character, keyCode, true);
            this.onSpellChanged(false);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (this.spectator) {
            return true;
        }
        if (this.commentEnabled) {
            switch (keyCode) {
                case 257: {
                    this.closeComment(true);
                    return true;
                }
                case 256: {
                    this.closeComment(false);
                    return true;
                }
            }
        }
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onKeyPressed(keyCode, scanCode, false)) {
            this.pushState(true);
            piece.onKeyPressed(keyCode, scanCode, true);
            this.onSpellChanged(false);
            return true;
        }
        if (this.spellNameField.isFocused() && keyCode == 258) {
            this.spellNameField.setFocused(false);
            return true;
        }
        if (!(this.spellNameField.isFocused() || this.panelWidget.panelEnabled || this.commentEnabled)) {
            int param = -1;
            for (int i = 0; i < 4; ++i) {
                if (!InputConstants.isKeyDown((long)this.getMinecraft().getWindow().getWindow(), (int)(49 + i))) continue;
                param = i;
            }
            switch (keyCode) {
                case 259: 
                case 261: {
                    if (GuiProgrammer.hasControlDown() && GuiProgrammer.hasShiftDown() && !this.spell.grid.isEmpty()) {
                        this.pushState(true);
                        this.spell = new Spell();
                        this.spellNameField.setValue("");
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (piece == null) break;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 258: {
                    this.spellNameField.setFocused(!this.spellNameField.isFocused());
                    this.setFocused((GuiEventListener)this.spellNameField);
                    return true;
                }
                case 265: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.TOP, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.TOP, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.TOP) || selectedY <= 0) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.hasShiftDown() && this.spell.grid.gridData[selectedX][--selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.BOTTOM);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 263: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.rotate(false);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.LEFT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.LEFT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.LEFT) || selectedX <= 0) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.hasShiftDown() && this.spell.grid.gridData[--selectedX][selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.RIGHT);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 262: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.rotate(true);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.RIGHT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.RIGHT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.RIGHT) || selectedX >= 8) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.hasShiftDown() && this.spell.grid.gridData[++selectedX][selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.LEFT);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 264: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.BOTTOM, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.BOTTOM, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.BOTTOM) || selectedY >= 8) break;
                    this.onSelectedChanged();
                    if (GuiProgrammer.hasShiftDown() && this.spell.grid.gridData[selectedX][++selectedY] == null) {
                        PieceConnector connector = new PieceConnector(this.spell);
                        connector.x = selectedX;
                        connector.y = selectedY;
                        connector.paramSides.put(connector.target, SpellParam.Side.TOP);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = connector;
                        this.onSpellChanged(false);
                    }
                    return true;
                }
                case 90: {
                    if (!GuiProgrammer.hasControlDown() || this.undoSteps.isEmpty()) break;
                    this.redoSteps.add(this.spell.copy());
                    this.spell = this.undoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 89: {
                    if (!GuiProgrammer.hasControlDown() || this.redoSteps.isEmpty()) break;
                    this.pushState(false);
                    this.spell = this.redoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 67: {
                    if (piece == null || !GuiProgrammer.hasControlDown()) break;
                    clipboard = piece.copy();
                    return true;
                }
                case 88: {
                    if (piece == null || !GuiProgrammer.hasControlDown()) break;
                    clipboard = piece.copy();
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 86: {
                    if (!SpellGrid.exists(selectedX, selectedY) || clipboard == null || !GuiProgrammer.hasControlDown()) break;
                    SpellPiece copy = clipboard.copy();
                    copy.x = selectedX;
                    copy.y = selectedY;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = copy;
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].isInGrid = true;
                    this.onSpellChanged(false);
                    return true;
                }
                case 68: {
                    if (piece == null || !GuiProgrammer.hasControlDown()) break;
                    this.commentField.setVisible(true);
                    this.commentField.setFocused(true);
                    this.commentField.setEditable(true);
                    this.spellNameField.setEditable(false);
                    this.commentField.setValue(piece.comment);
                    this.setFocused((GuiEventListener)this.commentField);
                    this.commentEnabled = true;
                    return true;
                }
                case 71: {
                    if (!GuiProgrammer.hasControlDown()) break;
                    this.shareToReddit = false;
                    if (GuiProgrammer.hasShiftDown() && GuiProgrammer.hasAltDown()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 82: {
                    if (!GuiProgrammer.hasControlDown()) break;
                    this.shareToReddit = true;
                    if (GuiProgrammer.hasShiftDown() && GuiProgrammer.hasAltDown()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 257: {
                    this.panelWidget.openPanel();
                    return true;
                }
            }
        }
        if (this.panelWidget.panelEnabled) {
            this.panelWidget.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.commentField.isFocused()) {
            this.commentField.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.spellNameField.isFocused()) {
            this.spellNameField.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean onSideButtonKeybind(SpellPiece piece, int param, SpellParam.Side side) {
        if (param > -1 && piece != null && piece.params.size() >= param) {
            for (Button button : this.configWidget.configButtons) {
                GuiButtonSideConfig config = (GuiButtonSideConfig)button;
                if (!config.matches(param, side)) continue;
                if (side != SpellParam.Side.OFF && piece.paramSides.get(piece.params.get(config.paramName)) == side) {
                    side = SpellParam.Side.OFF;
                    continue;
                }
                config.onPress();
                return true;
            }
        }
        return side == SpellParam.Side.OFF;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (!this.commentEnabled) {
            boolean did = this.spellNameField.mouseClicked(mouseX, mouseY, mouseButton);
            if (did) {
                this.spellNameField.setFocused(true);
                this.setFocused((GuiEventListener)this.spellNameField);
            } else {
                this.spellNameField.setFocused(false);
            }
            if (this.commentField.isVisible()) {
                this.commentField.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (this.cursorX != -1 && this.cursorY != -1) {
                selectedX = this.cursorX;
                selectedY = this.cursorY;
                if (mouseButton == 1 && !this.spectator && GuiProgrammer.hasShiftDown()) {
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                this.onSelectedChanged();
            }
        }
        for (GuiEventListener guieventlistener : this.children()) {
            if (!guieventlistener.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            if (mouseButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean isSpectator() {
        return this.spectator;
    }

    private void closeComment(boolean save) {
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        if (save && piece != null) {
            String text = this.commentField.getValue();
            this.pushState(true);
            piece.comment = text;
            this.onSpellChanged(false);
        }
        this.spellNameField.setEditable(!this.spectator && (piece == null || !piece.interceptKeystrokes()));
        this.commentField.setFocused(false);
        this.commentField.setVisible(false);
        this.commentField.setEditable(false);
        this.commentField.setValue("");
        this.commentEnabled = false;
    }

    public boolean shouldCloseOnEsc() {
        return !this.panelWidget.panelEnabled && !this.commentEnabled;
    }

    public List<Renderable> getButtons() {
        return this.renderables;
    }

    public boolean isPauseScreen() {
        return (Boolean)ConfigHandler.CLIENT.pauseGameInProgrammer.get();
    }

    static {
        clipboard = null;
        RenderType.CompositeState glState = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setLightmapState(new RenderStateShard.LightmapStateShard(true)).setCullState(new RenderStateShard.CullStateShard(false)).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).createCompositeState(false);
        LAYER = RenderType.create((String)"psi:programmer", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)glState);
    }
}

