/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.ArrayList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.base.ModDataComponents;

public class ItemExosuitController
extends Item
implements ISocketableController {
    public ItemExosuitController(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        if (playerIn.isShiftKeyDown()) {
            ItemStack[] stacks;
            if (!worldIn.isClientSide) {
                worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), PsiSoundHandler.compileError, SoundSource.PLAYERS, 0.25f, 1.0f);
            } else {
                playerIn.swing(hand);
            }
            for (ItemStack stack : stacks = this.getControlledStacks(playerIn, itemStackIn)) {
                ISocketable socketable = (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY);
                if (socketable == null) continue;
                socketable.setSelectedSlot(3);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public ItemStack[] getControlledStacks(Player player, ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)player.getInventory().armor.get(3 - i);
            if (armor.isEmpty() || !ISocketable.isSocketable(armor)) continue;
            stacks.add(armor);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    @Override
    public int getDefaultControlSlot(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.SELECTED_CONTROL_SLOT, (Object)0);
    }

    @Override
    public void setSelectedSlot(Player player, ItemStack stack, int controlSlot, int slot) {
        ISocketable socketable;
        stack.set(ModDataComponents.SELECTED_CONTROL_SLOT, (Object)controlSlot);
        ItemStack[] stacks = this.getControlledStacks(player, stack);
        if (controlSlot < stacks.length && !stacks[controlSlot].isEmpty() && (socketable = (ISocketable)stacks[controlSlot].getCapability(PsiAPI.SOCKETABLE_CAPABILITY)) != null) {
            socketable.setSelectedSlot(slot);
        }
    }
}

