/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.base.ModDataComponents;

public class ItemSpellDrive
extends Item {
    public ItemSpellDrive(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public static void setSpell(ItemStack stack, Spell spell) {
        if (spell != null) {
            stack.set(ModDataComponents.SPELL, (Object)spell);
            stack.set(DataComponents.RARITY, (Object)Rarity.RARE);
        } else {
            stack.remove(ModDataComponents.SPELL);
            stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
        }
    }

    @Nullable
    public static Spell getSpell(ItemStack stack) {
        return stack.has(ModDataComponents.SPELL) ? (Spell)stack.get(ModDataComponents.SPELL) : null;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        String name = super.getName(stack).getString();
        Spell cmp = ItemSpellDrive.getSpell(stack);
        if (cmp == null) {
            return Component.literal((String)name);
        }
        String spellName = cmp.name;
        if (spellName.isEmpty()) {
            return Component.literal((String)name);
        }
        return Component.literal((String)(name + " (" + String.valueOf(ChatFormatting.GREEN) + spellName + String.valueOf(ChatFormatting.RESET) + ")"));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Player playerIn = ctx.getPlayer();
        if (playerIn == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = ctx.getHand();
        Level worldIn = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = playerIn.getItemInHand(hand);
        BlockEntity tile = worldIn.getBlockEntity(pos);
        if (tile instanceof TileProgrammer) {
            TileProgrammer programmer = (TileProgrammer)tile;
            Spell spell = ItemSpellDrive.getSpell(stack);
            if (spell == null && programmer.canCompile()) {
                ItemSpellDrive.setSpell(stack, programmer.spell);
                if (!worldIn.isClientSide) {
                    worldIn.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (spell != null) {
                boolean enabled = programmer.isEnabled();
                if (enabled && !programmer.playerLock.isEmpty()) {
                    if (!programmer.playerLock.equals(playerIn.getName().getString())) {
                        if (!worldIn.isClientSide) {
                            playerIn.sendSystemMessage((Component)Component.translatable((String)"psimisc.not_your_programmer").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    programmer.playerLock = playerIn.getName().getString();
                }
                programmer.spell = spell;
                programmer.onSpellChanged();
                if (!worldIn.isClientSide) {
                    worldIn.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.PLAYERS, 0.5f, 1.0f);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(programmer);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        if (ItemSpellDrive.getSpell(itemStackIn) != null && playerIn.isShiftKeyDown()) {
            if (!worldIn.isClientSide) {
                worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), PsiSoundHandler.compileError, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else {
                playerIn.swing(hand);
            }
            ItemSpellDrive.setSpell(itemStackIn, null);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }
}

