/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import vazkii.psi.data.PsiBlockLootProvider;
import vazkii.psi.data.PsiBlockModelGenerator;
import vazkii.psi.data.PsiBlockTagProvider;
import vazkii.psi.data.PsiDamageTypeTagsProvider;
import vazkii.psi.data.PsiItemModelGenerator;
import vazkii.psi.data.PsiItemTagProvider;
import vazkii.psi.data.PsiRecipeGenerator;

@EventBusSubscriber(modid="psi")
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeServer()) {
            PsiBlockTagProvider blockTagProvider = new PsiBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTagProvider);
            generator.addProvider(true, (DataProvider)new PsiDamageTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new PsiItemTagProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
            generator.addProvider(true, (DataProvider)new PsiRecipeGenerator(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(PsiBlockLootProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new PsiBlockModelGenerator(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new PsiItemModelGenerator(packOutput, existingFileHelper));
        }
    }
}

