/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication;

import com.buuz135.replication.CommonEvents;
import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.MatterType;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.block.ChipStorageBlock;
import com.buuz135.replication.block.CreativeMatterTankBlock;
import com.buuz135.replication.block.DisintegratorBlock;
import com.buuz135.replication.block.IdentificationChamberBlock;
import com.buuz135.replication.block.MatterPipeBlock;
import com.buuz135.replication.block.MatterTankBlock;
import com.buuz135.replication.block.ReplicationTerminalBlock;
import com.buuz135.replication.block.ReplicatorBlock;
import com.buuz135.replication.block.tile.MatterPipeBlockEntity;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.client.ClientEvents;
import com.buuz135.replication.container.ReplicationTerminalContainer;
import com.buuz135.replication.data.RepBlockstateProvider;
import com.buuz135.replication.data.RepLangItemProvider;
import com.buuz135.replication.data.ReplicationBlockTagsProvider;
import com.buuz135.replication.data.ReplicationItemTagsProvider;
import com.buuz135.replication.data.ReplicationLootTableDataProvider;
import com.buuz135.replication.data.ReplicationRecipesProvider;
import com.buuz135.replication.item.CreativeMemoryChipItem;
import com.buuz135.replication.item.MatterBluePrintItem;
import com.buuz135.replication.item.MemoryChipItem;
import com.buuz135.replication.item.ReplicatorEnclosureItem;
import com.buuz135.replication.item.ReplicatorMotorItem;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.buuz135.replication.network.MatterNetwork;
import com.buuz135.replication.packet.MatterFluidSyncPacket;
import com.buuz135.replication.packet.PatternSyncStoragePacket;
import com.buuz135.replication.packet.ReplicationCalculationPacket;
import com.buuz135.replication.packet.TaskCancelPacket;
import com.buuz135.replication.packet.TaskCreatePacket;
import com.buuz135.replication.packet.TaskSyncPacket;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.block_network.NetworkFactory;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.NetworkRegistry;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElementRegistry;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.tab.TitaniumTab;
import guideme.Guide;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="replication")
public class Replication
extends ModuleController {
    public static String MOD_ID = "replication";
    public static NetworkHandler NETWORK = new NetworkHandler(MOD_ID);
    public static TitaniumTab TAB = new TitaniumTab(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"main"));
    public static final Logger LOGGER = LogManager.getLogger();

    public Replication(Dist dist, IEventBus modBus, ModContainer container) {
        super(container);
        NETWORK.registerMessage("pattern_sync_storage", PatternSyncStoragePacket.class);
        NETWORK.registerMessage("matter_fluid_sync", MatterFluidSyncPacket.class);
        NETWORK.registerMessage("task_create", TaskCreatePacket.class);
        NETWORK.registerMessage("task_sync", TaskSyncPacket.class);
        NETWORK.registerMessage("task_cancel", TaskCancelPacket.class);
        NETWORK.registerMessage("task_cancel_response", TaskCancelPacket.Response.class);
        NETWORK.registerMessage("replication_calculation", ReplicationCalculationPacket.class);
        ReplicationRegistry.init(modBus);
        CommonEvents.init();
        if (dist == Dist.CLIENT) {
            ClientEvents.init();
        }
        NetworkRegistry.INSTANCE.addFactory(MatterNetwork.MATTER, (NetworkFactory)new MatterNetwork.Factory());
        NetworkElementRegistry.INSTANCE.addFactory(DefaultMatterNetworkElement.ID, (NetworkElementFactory)new DefaultMatterNetworkElement.Factory());
        NBTManager.getInstance().scanTileClassForAnnotations(MatterPipeBlockEntity.class);
        EventManager.mod(RegisterCapabilitiesEvent.class).process(event -> {
            event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
                if (level instanceof ServerLevel && blockEntity instanceof MatterPipeBlockEntity) {
                    MatterPipeBlockEntity pipe = (MatterPipeBlockEntity)blockEntity;
                    if (NetworkManager.get((Level)level) != null && NetworkManager.get((Level)level).getElement(blockPos) != null && pipe.getNetwork() != null && pipe.getNetwork().getEnergyStorage() != null) {
                        return pipe.getNetwork().getEnergyStorage();
                    }
                }
                return null;
            }, new Block[]{ReplicationRegistry.Blocks.MATTER_NETWORK_PIPE.getBlock()});
            event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, blockPos, blockState, blockEntity, direction) -> {
                INetworkDirectionalConnection connection;
                Block patt0$temp = blockState.getBlock();
                if (patt0$temp instanceof INetworkDirectionalConnection && (connection = (INetworkDirectionalConnection)patt0$temp).canConnect(level, blockPos, blockState, direction) && blockEntity instanceof ReplicationMachine) {
                    ReplicationMachine machine = (ReplicationMachine)blockEntity;
                    return machine.getEnergyStorage();
                }
                return null;
            }, new Block[]{ReplicationRegistry.Blocks.DISINTEGRATOR.getBlock(), ReplicationRegistry.Blocks.IDENTIFICATION_CHAMBER.getBlock(), ReplicationRegistry.Blocks.REPLICATOR.getBlock()});
        }).subscribe();
        if (ModList.get().isLoaded("darkmodeeverywhere")) {
            EventManager.mod(InterModEnqueueEvent.class).process(interModEnqueueEvent -> InterModComms.sendTo((String)"darkmodeeverywhere", (String)"dme-shaderblacklist", () -> "com.buuz135.replication")).subscribe();
        }
    }

    protected void initModules() {
        this.addCreativeTab("main", () -> new ItemStack((ItemLike)ReplicationRegistry.Blocks.MATTER_NETWORK_PIPE.getBlock()), "replication", TAB);
        ReplicationRegistry.Blocks.MATTER_NETWORK_PIPE = this.getRegistries().registerBlockWithTile("matter_network_pipe", MatterPipeBlock::new, TAB);
        ReplicationRegistry.Blocks.REPLICATOR = this.getRegistries().registerBlockWithTile("replicator", ReplicatorBlock::new, TAB);
        ReplicationRegistry.Blocks.IDENTIFICATION_CHAMBER = this.getRegistries().registerBlockWithTile("identification_chamber", IdentificationChamberBlock::new, TAB);
        ReplicationRegistry.Blocks.DISINTEGRATOR = this.getRegistries().registerBlockWithTile("disintegrator", DisintegratorBlock::new, TAB);
        ReplicationRegistry.Blocks.MATTER_TANK = this.getRegistries().registerBlockWithTile("matter_tank", MatterTankBlock::new, TAB);
        ReplicationRegistry.Blocks.REPLICATION_TERMINAL = this.getRegistries().registerBlockWithTile("replication_terminal", ReplicationTerminalBlock::new, TAB);
        ReplicationRegistry.Blocks.CHIP_STORAGE = this.getRegistries().registerBlockWithTile("chip_storage", ChipStorageBlock::new, TAB);
        ReplicationRegistry.Blocks.CREATIVE_MATTER_TANK = this.getRegistries().registerBlockWithTile("creative_matter_tank", CreativeMatterTankBlock::new, TAB);
        ReplicationRegistry.Items.MEMORY_CHIP = this.getRegistries().registerGeneric(Registries.ITEM, "memory_chip", MemoryChipItem::new);
        ReplicationRegistry.Items.CREATIVE_MEMORY_CHIP = this.getRegistries().registerGeneric(Registries.ITEM, "creative_memory_chip", CreativeMemoryChipItem::new);
        ReplicationRegistry.Items.MATTER_BLUEPRINT = this.getRegistries().registerGeneric(Registries.ITEM, "matter_blueprint", MatterBluePrintItem::new);
        ReplicationRegistry.Sounds.TERMINAL_BUTTON = this.getRegistries().registerGeneric(Registries.SOUND_EVENT, "terminal_button", () -> SoundEvent.createFixedRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"terminal_button"), (float)8.0f));
        ReplicationTerminalContainer.TYPE = this.getRegistries().registerGeneric(Registries.MENU, "replication_terminal_container", () -> IMenuTypeExtension.create(ReplicationTerminalContainer::new));
        ReplicationRegistry.Blocks.DEEPSLATE_REPLICA_ORE = this.getRegistries().registerGeneric(Registries.BLOCK, "deepslate_replica_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE)));
        this.getRegistries().registerGeneric(Registries.ITEM, "deepslate_replica_ore", () -> {
            BlockItem item = new BlockItem((Block)ReplicationRegistry.Blocks.DEEPSLATE_REPLICA_ORE.get(), new Item.Properties());
            TAB.getTabList().add(item);
            return item;
        });
        ReplicationRegistry.Blocks.REPLICA_BLOCK = this.getRegistries().registerGeneric(Registries.BLOCK, "replica_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(4.5f, 3.0f).sound(SoundType.METAL)));
        this.getRegistries().registerGeneric(Registries.ITEM, "replica_block", () -> {
            BlockItem item = new BlockItem((Block)ReplicationRegistry.Blocks.REPLICA_BLOCK.get(), new Item.Properties());
            TAB.getTabList().add(item);
            return item;
        });
        ReplicationRegistry.Blocks.RAW_REPLICA_BLOCK = this.getRegistries().registerGeneric(Registries.BLOCK, "raw_replica_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
        this.getRegistries().registerGeneric(Registries.ITEM, "raw_replica_block", () -> {
            BlockItem item = new BlockItem((Block)ReplicationRegistry.Blocks.RAW_REPLICA_BLOCK.get(), new Item.Properties());
            TAB.getTabList().add(item);
            return item;
        });
        ReplicationRegistry.Items.RAW_REPLICA = this.getRegistries().registerGeneric(Registries.ITEM, "raw_replica", () -> {
            Item item = new Item(new Item.Properties());
            TAB.getTabList().add(item);
            return item;
        });
        ReplicationRegistry.Items.REPLICA_INGOT = this.getRegistries().registerGeneric(Registries.ITEM, "replica_ingot", () -> {
            Item item = new Item(new Item.Properties());
            TAB.getTabList().add(item);
            return item;
        });
        ReplicationRegistry.Items.REPLICATOR_MOTOR = this.getRegistries().registerGeneric(Registries.ITEM, "replicator_motor", ReplicatorMotorItem::new);
        ReplicationRegistry.Items.REPLICATOR_ENCLOSURE = this.getRegistries().registerGeneric(Registries.ITEM, "replicator_enclosure", ReplicatorEnclosureItem::new);
        EventManager.mod(BuildCreativeModeTabContentsEvent.class, (EventPriority)EventPriority.LOW).process(buildCreativeModeTabContentsEvent -> {
            if (buildCreativeModeTabContentsEvent.getTabKey().location().equals((Object)TAB.getResourceLocation())) {
                for (IMatterType value : ReplicationRegistry.MATTER_TYPES_REGISTRY.stream().toList()) {
                    if (value.equals(MatterType.EMPTY)) continue;
                    MatterStack matterStack = new MatterStack(value, (double)ReplicationConfig.MatterTank.CAPACITY);
                    CompoundTag tile = new CompoundTag();
                    CompoundTag tank = matterStack.writeToNBT(new CompoundTag());
                    tile.put("tank", (Tag)tank);
                    ItemStack item = new ItemStack((ItemLike)ReplicationRegistry.Blocks.MATTER_TANK);
                    item.set(ReplicationAttachments.TILE, (Object)tile);
                    buildCreativeModeTabContentsEvent.accept(item);
                }
                ItemStack motorTemplate = new ItemStack(ReplicationRegistry.Items.MATTER_BLUEPRINT);
                CompoundTag tagC = new CompoundTag();
                tagC.put("Item", new ItemStack(ReplicationRegistry.Items.REPLICATOR_MOTOR).saveOptional((HolderLookup.Provider)ReplicationRegistry.registryAccess()));
                tagC.putDouble("Progress", 1.0);
                motorTemplate.set(ReplicationAttachments.BLUEPRINT, (Object)tagC);
                buildCreativeModeTabContentsEvent.accept(motorTemplate);
                for (IMatterType value : ReplicationRegistry.MATTER_TYPES_REGISTRY.stream().toList()) {
                    if (value.equals(MatterType.EMPTY)) continue;
                    MatterStack matterStack = new MatterStack(value, (double)ReplicationConfig.MatterTank.CAPACITY);
                    CompoundTag tile = new CompoundTag();
                    CompoundTag tank = matterStack.writeToNBT(new CompoundTag());
                    tile.put("tank", (Tag)tank);
                    ItemStack item = new ItemStack((ItemLike)ReplicationRegistry.Blocks.CREATIVE_MATTER_TANK);
                    item.set(ReplicationAttachments.TILE, (Object)tile);
                    buildCreativeModeTabContentsEvent.accept(item);
                }
            }
        }).subscribe();
        ReplicationCalculation.init();
        if (ModList.get().isLoaded("guideme")) {
            Guide.builder((ResourceLocation)ResourceLocation.parse((String)"replication:main")).build();
        }
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            giver.addReward(new Reward(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"aura"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> dist -> {}, Arrays.stream(AuraType.values()).map(Enum::toString).collect(Collectors.toList()).toArray(new String[0])));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void addDataProvider(GatherDataEvent event) {
        super.addDataProvider(event);
        List<Block> blocks = BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals(MOD_ID)).toList();
        event.getGenerator().addProvider(true, (DataProvider)new RepBlockstateProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper(), blocks));
        event.getGenerator().addProvider(true, (DataProvider)new ReplicationLootTableDataProvider(event.getGenerator(), () -> blocks, event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new RepLangItemProvider(event.getGenerator(), MOD_ID, "en_us", blocks));
        ReplicationBlockTagsProvider blockTags = new ReplicationBlockTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), MOD_ID, event.getExistingFileHelper(), blocks);
        event.getGenerator().addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new ReplicationItemTagsProvider(event.getGenerator(), event.getLookupProvider(), blockTags.contentsGetter(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new ReplicationRecipesProvider(event.getGenerator(), () -> blocks, event.getLookupProvider()));
    }

    public static enum AuraType {
        REPLICATION(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"textures/block/shader_only_green.png"), true),
        ORE(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"textures/block/replica_ore.png"), true),
        BLUE_BOSS(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/boss_bar/blue_background.png"), true),
        PINK_BOSS(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/boss_bar/pink_background.png"), true),
        EVIL(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/sprites/container/beacon/cancel.png"), true),
        POWDER(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/powder_snow_outline.png"), true),
        FORCE_FIELD(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/forcefield.png"), false),
        UNDERWATER(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/underwater.png"), false),
        SPOOK(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/pumpkinblur.png"), false),
        END(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/end_sky.png"), false),
        CLOUDS(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/clouds.png"), false),
        RAIN(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/rain.png"), true),
        SGA(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/font/ascii_sga.png"), false),
        ENCHANTED(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/enchanted_glint_item.png"), true),
        RECIPE_BOOK(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/recipe_book.png"), true),
        END_PORTAL(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/end_portal.png"), true),
        MOON(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/moon_phases.png"), true);

        private final ResourceLocation resourceLocation;
        private final boolean usePipeShader;

        private AuraType(ResourceLocation resourceLocation, boolean enableBlend) {
            this.resourceLocation = resourceLocation;
            this.usePipeShader = enableBlend;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public boolean isUsePipeShader() {
            return this.usePipeShader;
        }
    }
}

