/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication;

import com.buuz135.replication.Replication;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ReplicationAttachments {
    public static final DeferredRegister<DataComponentType<?>> DR = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)Replication.MOD_ID);
    public static final Supplier<DataComponentType<CompoundTag>> TANK_STORAGE = ReplicationAttachments.register("matter_tank", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> BLUEPRINT = ReplicationAttachments.register("blueprint", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> TILE = ReplicationAttachments.register("tile", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> CHIP_PATTERNS = ReplicationAttachments.register("chip_patterns", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));

    private static <T> ComponentSupplier<T> register(String name, Supplier<T> defaultVal, UnaryOperator<DataComponentType.Builder<T>> op) {
        DeferredHolder registered = DR.register(name, () -> ((DataComponentType.Builder)op.apply(DataComponentType.builder())).build());
        return new ComponentSupplier<T>(registered, defaultVal);
    }

    public static class ComponentSupplier<T>
    implements Supplier<DataComponentType<T>> {
        private final Supplier<DataComponentType<T>> type;
        private final Supplier<T> defaultSupplier;

        public ComponentSupplier(Supplier<DataComponentType<T>> type, Supplier<T> defaultSupplier) {
            this.type = type;
            this.defaultSupplier = Suppliers.memoize(defaultSupplier::get);
        }

        public T get(ItemStack stack) {
            return (T)stack.getOrDefault(this.type, this.defaultSupplier.get());
        }

        @Override
        public DataComponentType<T> get() {
            return this.type.get();
        }
    }
}

