/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class MatterPipeBlockEntity
extends NetworkBlockEntity<MatterPipeBlockEntity> {
    @Save
    private boolean needsToRecreateEnergyStorage = false;

    public MatterPipeBlockEntity(BasicTileBlock<MatterPipeBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, MatterPipeBlockEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (level.getGameTime() % 2L == 0L) {
            if (this.needsToRecreateEnergyStorage) {
                level.invalidateCapabilities(this.worldPosition);
                this.needsToRecreateEnergyStorage = false;
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
            for (Direction value : Direction.values()) {
                IEnergyStorage capability = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(value), (Object)value.getOpposite());
                BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative(value));
                if (capability == null || tile instanceof MatterPipeBlockEntity || this.getNetwork() == null) continue;
                int simulatedExtract = this.getNetwork().getEnergyStorage().extractEnergy(ReplicationConfig.MatterPipe.POWER_TRANSFER, true);
                int realExtracted = capability.receiveEnergy(simulatedExtract, false);
                this.getNetwork().getEnergyStorage().extractEnergy(realExtracted, false);
            }
        }
    }

    @NotNull
    public MatterPipeBlockEntity getSelf() {
        return this;
    }

    @Override
    protected NetworkElement createElement(Level level, BlockPos pos) {
        return super.createElement(level, pos);
    }

    public void setNeedsToRecreateEnergyStorage(boolean needsToRecreateEnergyStorage) {
        this.needsToRecreateEnergyStorage = needsToRecreateEnergyStorage;
    }
}

