/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.api.matter_fluid.component.MatterTankComponent;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class NetworkBlockEntity<T extends ActiveTile<T>>
extends ActiveTile<T>
implements ITickableBlockEntity<T> {
    private List<MatterTankComponent<T>> matterTankComponents = new ArrayList<MatterTankComponent<T>>();
    private boolean unloaded;

    public NetworkBlockEntity(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.matterTankComponents.forEach(matterTankComponent -> matterTankComponent.getScreenAddons().forEach(arg_0 -> ((NetworkBlockEntity)this).addGuiAddonFactory(arg_0)));
    }

    public void onLoad() {
        NetworkManager networkManager;
        super.onLoad();
        if (!this.level.isClientSide && (networkManager = NetworkManager.get((Level)this.level)).getElement(this.worldPosition) == null) {
            networkManager.addElement(this.createElement(this.level, this.worldPosition));
        }
    }

    public void addMatterTank(MatterTankComponent<T> matterTankComponent) {
        this.matterTankComponents.add(matterTankComponent);
        matterTankComponent.setComponentHarness(this.getSelf());
        matterTankComponent.getContainerAddons().forEach(arg_0 -> ((NetworkBlockEntity)this).addContainerAddonFactory(arg_0));
        Runnable change = matterTankComponent.getOnContentChange();
        matterTankComponent.setOnContentChange(() -> {
            this.syncObject(matterTankComponent);
            change.run();
        });
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide && !this.unloaded) {
            NetworkManager networkManager = NetworkManager.get((Level)this.level);
            NetworkElement pipe = networkManager.getElement(this.worldPosition);
            if (pipe != null) {
                // empty if block
            }
            networkManager.removeElement(this.worldPosition);
            Network network = pipe.getNetwork();
            if (network instanceof MatterNetwork) {
                MatterNetwork matterNetwork = (MatterNetwork)network;
                matterNetwork.removeElement(pipe);
            }
        }
    }

    protected NetworkElement createElement(Level level, BlockPos pos) {
        return new DefaultMatterNetworkElement(level, pos);
    }

    public MatterNetwork getNetwork() {
        return (MatterNetwork)NetworkManager.get((Level)this.level).getElement(this.worldPosition).getNetwork();
    }

    public List<MatterTankComponent<T>> getMatterTankComponents() {
        return this.matterTankComponents;
    }
}

