/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.IMatterPatternHolder;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.container.ReplicationTerminalContainer;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ReplicationTerminalBlockEntity
extends NetworkBlockEntity<ReplicationTerminalBlockEntity> {
    @Save
    private InventoryComponent<ReplicationTerminalBlockEntity> output;
    @Save
    private int sortingTypeValue = 0;
    @Save
    private int sortingDirection = 1;
    @Save
    private int matterOpediaSortingTypeValue = 0;
    @Save
    private int matterOpediaSortingDirection = 1;
    private TerminalPlayerTracker terminalPlayerTracker = new TerminalPlayerTracker();

    public ReplicationTerminalBlockEntity(BasicTileBlock<ReplicationTerminalBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.output = new InventoryComponent("output", 11, 131, 18).setRange(9, 2);
        this.addInventory(this.output);
    }

    @Override
    public void initClient() {
        super.initClient();
    }

    @NotNull
    public ReplicationTerminalBlockEntity getSelf() {
        return this;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, ReplicationTerminalBlockEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        this.terminalPlayerTracker.checkIfValid();
    }

    public ItemInteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            for (NetworkElement chipSupplier : this.getNetwork().getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                if (!(tile instanceof IMatterPatternHolder)) continue;
                IMatterPatternHolder holder = (IMatterPatternHolder)tile;
                this.getNetwork().sendPatternSyncPacket(serverPlayer, holder, tile.getBlockPos());
            }
            ReplicationRegistry.MATTER_TYPES_REGISTRY.forEach(iMatterType -> this.getNetwork().sendMatterSyncPacket(serverPlayer, this.getNetwork().calculateMatterAmount((IMatterType)iMatterType), (IMatterType)iMatterType));
            this.getLevel().getServer().submitAsync(() -> this.getNetwork().getTaskManager().getPendingTasks().values().forEach(task -> this.getNetwork().sendTaskSyncPacket(serverPlayer, (IReplicationTask)task)));
            serverPlayer.openMenu((MenuProvider)this, buffer -> {
                LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition));
                buffer.writeUtf(this.getNetwork().getId());
                buffer.writeInt(this.sortingTypeValue);
                buffer.writeInt(this.sortingDirection);
                buffer.writeInt(this.matterOpediaSortingTypeValue);
                buffer.writeInt(this.matterOpediaSortingDirection);
            });
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (id == 999) {
            String type = compound.getString("type");
            int value = compound.getInt("state");
            if (type.equals("SORTING_TYPE")) {
                this.sortingTypeValue = value;
                this.syncObject(this.sortingTypeValue);
            } else if (type.equals("SORTING_ACTION")) {
                this.sortingDirection = value;
                this.syncObject(this.sortingDirection);
            } else if (type.equals("MATTEROPEDIA_TYPE")) {
                this.matterOpediaSortingTypeValue = value;
                this.syncObject(this.matterOpediaSortingTypeValue);
            } else if (type.equals("MATTEROPEDIA_DIRECTION")) {
                this.matterOpediaSortingDirection = value;
                this.syncObject(this.matterOpediaSortingDirection);
            }
        }
    }

    public TerminalPlayerTracker getTerminalPlayerTracker() {
        return this.terminalPlayerTracker;
    }

    public InventoryComponent<ReplicationTerminalBlockEntity> getOutput() {
        return this.output;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new ReplicationTerminalContainer(this, inventoryPlayer, menu);
    }

    public static class TerminalPlayerTracker {
        private List<ServerPlayer> players = new ArrayList<ServerPlayer>();
        private List<UUID> uuidsToRemove = new ArrayList<UUID>();
        private List<ServerPlayer> playersToAdd = new ArrayList<ServerPlayer>();

        public void checkIfValid() {
            ArrayList<ServerPlayer> output = new ArrayList<ServerPlayer>(this.playersToAdd);
            ArrayList<ServerPlayer> input = new ArrayList<ServerPlayer>(this.players);
            for (ServerPlayer serverPlayer : input) {
                if (!(serverPlayer.containerMenu instanceof ReplicationTerminalContainer) || this.uuidsToRemove.contains(serverPlayer.getUUID())) continue;
                output.add(serverPlayer);
            }
            this.players = output;
            this.uuidsToRemove = new ArrayList<UUID>();
            this.playersToAdd = new ArrayList<ServerPlayer>();
        }

        public void removePlayer(ServerPlayer serverPlayer) {
            this.uuidsToRemove.add(serverPlayer.getUUID());
        }

        public void addPlayer(ServerPlayer serverPlayer) {
            this.playersToAdd.add(serverPlayer);
        }

        public List<ServerPlayer> getPlayers() {
            return this.players;
        }
    }
}

