/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client;

import com.buuz135.replication.Replication;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.client.MatterTooltipComponent;
import com.buuz135.replication.util.NumberUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class MatterTooltipClientComponent
implements ClientTooltipComponent {
    public static final ResourceLocation BAR = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/matter_bar.png");
    private final MatterTooltipComponent instance;

    public MatterTooltipClientComponent(MatterTooltipComponent instance) {
        this.instance = instance;
    }

    public int getHeight() {
        return 24;
    }

    public int getWidth(Font p_169952_) {
        return 19 * this.instance.getInstance().getValues().size();
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int xModifier = 0;
        for (MatterValue value : this.instance.getInstance().getValues().values()) {
            xModifier += this.renderInformationPill(value, guiGraphics, x + xModifier, y);
        }
    }

    private int renderInformationPill(MatterValue instance, GuiGraphics guiGraphics, int x, int y) {
        IMatterType matterType = instance.getMatter();
        float[] color = matterType.getColor().get();
        boolean glitch = Minecraft.getInstance().level.random.nextDouble() < 0.001;
        boolean glitch2 = Minecraft.getInstance().level.random.nextDouble() < 0.003;
        int numberLength = ("" + Mth.ceil((double)instance.getAmount())).toCharArray().length;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)("textures/gui/mattertypes/" + matterType.getName().toLowerCase() + ".png")), x + (glitch ? 1 : 0), y + (glitch ? 1 : 0), 0.0f, 0.0f, 16, 16, 16, 16);
        float size = 1.0f;
        guiGraphics.blit(BAR, x + (glitch ? 1 : 0) - 1, y + (glitch ? 1 : 0) - 1, 60.0f * size, 57.0f * size, 18, 22, (int)(128.0f * size), (int)(128.0f * size));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().pushPose();
        float scale = 0.5f;
        guiGraphics.pose().scale(scale, scale, scale);
        String number = NumberUtils.getFormatedBigNumber(instance.getAmount());
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, number, (int)((float)(x + (glitch ? 1 : 0) + 8) / scale), (int)((float)(y + (glitch ? 1 : 0) + 15) / scale), new Color(color[0], color[1], color[2], color[3]).getRGB());
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        return 19;
    }

    private void renderEncodedTextNumber(String number, int x, int y, GuiGraphics guiGraphics) {
        for (int i = 0; i < number.toCharArray().length; ++i) {
            int parseInt = Integer.parseInt("" + number.toCharArray()[i]);
            guiGraphics.blit(BAR, x + i * 10, y, (float)(parseInt * 9), 27.0f, 9, 9, 128, 128);
        }
    }
}

