/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.render;

import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class ChipStorageRenderer<T extends ChipStorageBlockEntity>
implements BlockEntityRenderer<T> {
    public static List<BakedModel> CHIP_MODELS = new ArrayList<BakedModel>();

    public ChipStorageRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ChipStorageBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)entity.getBlockState().getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (facing == Direction.EAST) {
            poseStack.translate(1.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.translate(0.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        for (int i = 0; i < entity.getChips().getSlots(); ++i) {
            ItemStack stack = entity.getChips().getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(RenderType.cutout()), null, CHIP_MODELS.get(i), 255.0f, 255.0f, 255.0f, combinedLightIn, combinedOverlayIn);
        }
    }
}

