/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.inventory;

import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sunekaer.toolkit.commands.inventory.InventoryCollector;
import com.sunekaer.toolkit.network.SetCopy;
import com.sunekaer.toolkit.utils.CommandUtils;
import dev.architectury.networking.NetworkManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CopyCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"copy").then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(InventoryCollector::suggestions).executes(ctx -> CopyCommand.copy((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.argument((String)"outputType", (ArgumentType)StringArgumentType.word()).suggests(CopyCommand::outputTypeSuggestions).executes(ctx -> CopyCommand.copy((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"outputType")))));
    }

    private static CompletableFuture<Suggestions> outputTypeSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        List<OutputType> sortedTypes = Stream.of(OutputType.values()).sorted(Comparator.comparingInt(a -> a.order)).toList();
        for (OutputType value : sortedTypes) {
            suggestionsBuilder.suggest(value.name);
        }
        return suggestionsBuilder.buildFuture();
    }

    private static int copy(CommandContext<CommandSourceStack> context, @Nullable String outputType) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        InventoryCollector type = InventoryCollector.fromString(StringArgumentType.getString(context, (String)"type"));
        OutputType computedOutputType = OutputType.PLAIN;
        if (outputType != null) {
            try {
                computedOutputType = OutputType.valueOf(outputType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                source.sendFailure((Component)Component.literal((String)"Invalid output type"));
                return 0;
            }
        }
        if (type == null) {
            source.sendFailure((Component)Component.literal((String)"Invalid type"));
            return 0;
        }
        ServerPlayer player = source.getPlayerOrException();
        List<ItemStack> itemCollection = type.itemCollector.apply((Player)player);
        List<ItemStack> nonEmptyItems = itemCollection.stream().filter(stack -> !stack.isEmpty()).toList();
        String outputString = computedOutputType.function.apply(nonEmptyItems, (HolderLookup.Provider)source.registryAccess());
        source.sendSuccess(() -> Component.translatable((String)"commands.toolkit.clipboard.copied"), true);
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SetCopy(outputString));
        return 1;
    }

    static enum OutputType {
        KUBEJS(4, "kubejs", (items, lookup) -> {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(CommandUtils.NEW_LINE);
            String tab = "  ";
            for (ItemStack stack : items) {
                String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
                Object withNBT = "";
                CompoundTag nbt = (CompoundTag)stack.save(lookup);
                if (nbt.contains("components")) {
                    withNBT = (String)withNBT + String.valueOf(nbt.get("components"));
                }
                builder.append("  ").append("{").append(CommandUtils.NEW_LINE);
                builder.append("  ").append("  ").append("item: ").append('\"').append(itemName).append('\"').append(",").append(CommandUtils.NEW_LINE);
                if (!((String)withNBT).isEmpty()) {
                    builder.append("  ").append("  ").append("nbt: ").append('\"').append((String)withNBT).append('\"').append(",").append(CommandUtils.NEW_LINE);
                }
                if (stack != items.get(items.size() - 1)) {
                    builder.append("  ").append("},");
                } else {
                    builder.append("  ").append("}");
                }
                builder.append(CommandUtils.NEW_LINE);
            }
            builder.append("]");
            return builder.toString();
        }),
        KUBEJS_NATIVE(5, "kubejs_native", (items, lookup) -> {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(CommandUtils.NEW_LINE);
            String tab = "  ";
            for (ItemStack stack : items) {
                String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
                Object withNBT = "";
                CompoundTag nbt = (CompoundTag)stack.save(lookup);
                if (nbt.contains("components")) {
                    withNBT = (String)withNBT + String.valueOf(nbt.get("components"));
                }
                String itemString = String.format("%s%s", stack.getCount() > 1 ? stack.getCount() + "x " : "", itemName);
                if (((String)withNBT).isEmpty()) {
                    builder.append("  ").append("\"").append(itemString).append("\"").append(",");
                }
                if (!((String)withNBT).isEmpty()) {
                    builder.append("  ").append("Item.of(\"").append(itemName).append("\").withNbt(").append((String)withNBT).append("),");
                }
                builder.append(CommandUtils.NEW_LINE);
            }
            builder.append("]");
            return builder.toString();
        }),
        JSON(3, "json", (items, lookup) -> {
            List<Map> output = items.stream().map(stack -> {
                String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
                CompoundTag nbt = (CompoundTag)stack.save(lookup);
                if (nbt.contains("components")) {
                    return Map.of("item", itemName, "nbt", Objects.requireNonNull(nbt.get("components")));
                }
                return Map.of("item", itemName);
            }).toList();
            return new Gson().newBuilder().setPrettyPrinting().create().toJson(output);
        }),
        SNBT(2, "snbt", (items, lookup) -> {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (ItemStack stack : items) {
                list.add((Object)stack.save(lookup));
            }
            tag.put("items", (Tag)list);
            return new SnbtPrinterTagVisitor().visit((Tag)tag);
        }),
        NBT(1, "nbt", (items, lookup) -> {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (ItemStack stack : items) {
                list.add((Object)stack.save(lookup));
            }
            tag.put("items", (Tag)list);
            return tag.toString();
        }),
        CRAFTTWEAKER(5, "crafttweaker", (items, lookup) -> {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(CommandUtils.NEW_LINE);
            for (ItemStack stack : items) {
                String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
                Object withNBT = "";
                CompoundTag nbt = (CompoundTag)stack.save(lookup);
                if (nbt.contains("components")) {
                    withNBT = (String)withNBT + String.valueOf(nbt.get("components"));
                }
                builder.append("    ").append("<item:").append(itemName).append(">");
                if (!((String)withNBT).isEmpty()) {
                    builder.append(".withTag(").append((String)withNBT).append(")");
                }
                builder.append(",").append(CommandUtils.NEW_LINE);
            }
            builder.append("]").append(CommandUtils.NEW_LINE);
            return builder.toString();
        }),
        PLAIN(0, "plain", (items, lookup) -> {
            StringBuilder builder = new StringBuilder();
            for (ItemStack stack : items) {
                String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
                Object withNBT = "";
                CompoundTag nbt = (CompoundTag)stack.save(lookup);
                if (nbt.contains("components")) {
                    withNBT = (String)withNBT + String.valueOf(nbt.get("components"));
                }
                builder.append(itemName).append((String)withNBT).append(CommandUtils.NEW_LINE);
            }
            return builder.toString();
        }),
        CSV(6, "csv", (items, lookup) -> {
            StringBuilder builder = new StringBuilder();
            builder.append("item,nbt").append(CommandUtils.NEW_LINE);
            for (ItemStack stack : items) {
                String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString();
                Object withNBT = "";
                CompoundTag nbt = (CompoundTag)stack.save(lookup);
                if (nbt.contains("components")) {
                    withNBT = (String)withNBT + String.valueOf(nbt.get("components"));
                }
                builder.append(itemName).append(",").append((String)withNBT).append(CommandUtils.NEW_LINE);
            }
            return builder.toString();
        });

        final int order;
        final String name;
        final BiFunction<List<ItemStack>, HolderLookup.Provider, String> function;

        private OutputType(int order, String name, BiFunction<List<ItemStack>, HolderLookup.Provider, String> function) {
            this.order = order;
            this.name = name;
            this.function = function;
        }
    }
}

