/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.items;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;

public class SlayerCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"slayer").requires(cs -> cs.hasPermission(2))).executes(ctx -> SlayerCommand.giveItem(((CommandSourceStack)ctx.getSource()).getPlayerOrException()));
    }

    private static int giveItem(ServerPlayer player) {
        ItemEntity drop;
        ItemStack itemstack = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        itemstack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"commands.dragonslayer.name"));
        List<ResourceKey> enchantments = List.of(Enchantments.SHARPNESS, Enchantments.KNOCKBACK, Enchantments.UNBREAKING, Enchantments.BANE_OF_ARTHROPODS, Enchantments.SMITE, Enchantments.SWEEPING_EDGE);
        ItemEnchantments enchants = (ItemEnchantments)itemstack.get(DataComponents.ENCHANTMENTS);
        ItemEnchantments.Mutable mutableEnchants = new ItemEnchantments.Mutable(enchants);
        Registry enchantmentRegistry = player.server.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        enchantments.forEach(e -> mutableEnchants.set((Holder)enchantmentRegistry.getHolderOrThrow(e), Short.MAX_VALUE));
        itemstack.set(DataComponents.ENCHANTMENTS, (Object)mutableEnchants.toImmutable());
        boolean added = player.getInventory().add(itemstack.copy());
        if (!added && (drop = player.drop(itemstack.copy(), false)) != null) {
            drop.setNoPickUpDelay();
            drop.setTarget(player.getUUID());
        }
        return 1;
    }
}

