/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.aaron.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.aaronhowser.mods.aaron.client.render.AaronRenderTypes;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005JP\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005JP\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005JP\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005J&\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000eJ&\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000eJF\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000eJZ\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020*2\b\b\u0002\u00100\u001a\u00020\u000e2\b\b\u0002\u00101\u001a\u00020\u000eJ$\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u0002062\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005Jx\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00052\b\b\u0002\u0010@\u001a\u00020\u00052\b\b\u0002\u0010A\u001a\u00020\u00052\b\b\u0002\u0010B\u001a\u00020\u00052\b\b\u0002\u00100\u001a\u00020\u000e2\b\b\u0002\u00101\u001a\u00020\u000eJ\u0084\u0001\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000e2\b\b\u0002\u0010@\u001a\u00020\u00052\b\b\u0002\u0010A\u001a\u00020\u00052\b\b\u0002\u0010B\u001a\u00020\u0005J\u000e\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020IJ\u000e\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020LR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u000e0KX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Ldev/aaronhowser/mods/aaron/client/render/RenderUtil;", "", "<init>", "()V", "HALF_SQRT_3", "", "renderRaysDoubleLayer", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "time", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "centerColor", "", "outerColor", "amountRays", "rayLength", "rayWidth", "renderDragonRays", "renderDragonRaysDepth", "renderRays", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "renderLineThroughWalls", "start", "Lnet/minecraft/world/phys/Vec3;", "end", "color", "renderCubeThroughWalls", "center", "width", "posX", "", "posY", "posZ", "length", "height", "renderTexturedCube", "renderType", "Lnet/minecraft/client/renderer/RenderType;", "topTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "bottomTextureLocation", "northTextureLocation", "southTextureLocation", "eastTextureLocation", "westTextureLocation", "light", "overlay", "getVertices", "", "Lorg/joml/Vector3f;", "direction", "Lnet/minecraft/core/Direction;", "addVertex", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", "consumer", "x", "y", "z", "u", "v", "normalX", "normalY", "normalZ", "u1", "v1", "u2", "v2", "getColorFromFluid", "fluidStack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "SPRITE_AVERAGE_COLOR_CACHE", "", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getSpriteAverageColor", "sprite", "aaron-1.21.1"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    @NotNull
    private static final Map<TextureAtlasSprite, Integer> SPRITE_AVERAGE_COLOR_CACHE = new LinkedHashMap();

    private RenderUtil() {
    }

    public final void renderRaysDoubleLayer(@NotNull PoseStack poseStack, float time, @NotNull MultiBufferSource bufferSource, int centerColor, int outerColor, int amountRays, float rayLength, float rayWidth) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        this.renderDragonRays(poseStack, time, bufferSource, centerColor, outerColor, amountRays, rayLength, rayWidth);
        this.renderDragonRaysDepth(poseStack, time, bufferSource, centerColor, outerColor, amountRays, rayLength, rayWidth);
    }

    public static /* synthetic */ void renderRaysDoubleLayer$default(RenderUtil renderUtil, PoseStack poseStack, float f, MultiBufferSource multiBufferSource, int n, int n2, int n3, float f2, float f3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n = -16777216;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 2910832;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 15;
        }
        if ((n4 & 0x40) != 0) {
            f2 = 0.325f;
        }
        if ((n4 & 0x80) != 0) {
            f3 = 0.15f;
        }
        renderUtil.renderRaysDoubleLayer(poseStack, f, multiBufferSource, n, n2, n3, f2, f3);
    }

    public final void renderDragonRays(@NotNull PoseStack poseStack, float time, @NotNull MultiBufferSource bufferSource, int centerColor, int outerColor, int amountRays, float rayLength, float rayWidth) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.dragonRays());
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        this.renderRays(poseStack, time, vertexConsumer, centerColor, outerColor, amountRays, rayLength, rayWidth);
    }

    public static /* synthetic */ void renderDragonRays$default(RenderUtil renderUtil, PoseStack poseStack, float f, MultiBufferSource multiBufferSource, int n, int n2, int n3, float f2, float f3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n = -16777216;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 2910832;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 15;
        }
        if ((n4 & 0x40) != 0) {
            f2 = 0.325f;
        }
        if ((n4 & 0x80) != 0) {
            f3 = 0.15f;
        }
        renderUtil.renderDragonRays(poseStack, f, multiBufferSource, n, n2, n3, f2, f3);
    }

    public final void renderDragonRaysDepth(@NotNull PoseStack poseStack, float time, @NotNull MultiBufferSource bufferSource, int centerColor, int outerColor, int amountRays, float rayLength, float rayWidth) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.dragonRaysDepth());
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        this.renderRays(poseStack, time, vertexConsumer, centerColor, outerColor, amountRays, rayLength, rayWidth);
    }

    public static /* synthetic */ void renderDragonRaysDepth$default(RenderUtil renderUtil, PoseStack poseStack, float f, MultiBufferSource multiBufferSource, int n, int n2, int n3, float f2, float f3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n = -16777216;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 2910832;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 15;
        }
        if ((n4 & 0x40) != 0) {
            f2 = 0.325f;
        }
        if ((n4 & 0x80) != 0) {
            f3 = 0.15f;
        }
        renderUtil.renderDragonRaysDepth(poseStack, f, multiBufferSource, n, n2, n3, f2, f3);
    }

    public final void renderRays(@NotNull PoseStack poseStack, float time, @NotNull VertexConsumer vertexConsumer, int centerColor, int outerColor, int amountRays, float rayLength, float rayWidth) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        poseStack.pushPose();
        RandomSource randomSource = RandomSource.create((long)432L);
        Vector3f vec0 = new Vector3f();
        Vector3f vec1 = new Vector3f();
        Vector3f vec2 = new Vector3f();
        Vector3f vec3 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        for (int rayIndex = 0; rayIndex < amountRays; ++rayIndex) {
            quaternionf.rotateXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2), randomSource.nextFloat() * ((float)Math.PI * 2) + time * 1.5707964f);
            poseStack.mulPose(quaternionf);
            vec1.set(-HALF_SQRT_3 * rayWidth, rayLength, -0.5f * rayWidth);
            vec2.set(HALF_SQRT_3 * rayWidth, rayLength, -0.5f * rayWidth);
            vec3.set(0.0f, rayLength, rayWidth);
            PoseStack.Pose pose = poseStack.last();
            vertexConsumer.addVertex(pose, vec0).setColor(centerColor);
            vertexConsumer.addVertex(pose, vec1).setColor(outerColor);
            vertexConsumer.addVertex(pose, vec2).setColor(outerColor);
            vertexConsumer.addVertex(pose, vec0).setColor(centerColor);
            vertexConsumer.addVertex(pose, vec2).setColor(outerColor);
            vertexConsumer.addVertex(pose, vec3).setColor(outerColor);
            vertexConsumer.addVertex(pose, vec0).setColor(centerColor);
            vertexConsumer.addVertex(pose, vec3).setColor(outerColor);
            vertexConsumer.addVertex(pose, vec1).setColor(outerColor);
        }
        poseStack.popPose();
    }

    public static /* synthetic */ void renderRays$default(RenderUtil renderUtil, PoseStack poseStack, float f, VertexConsumer vertexConsumer, int n, int n2, int n3, float f2, float f3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n = -16777216;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 2910832;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 15;
        }
        if ((n4 & 0x40) != 0) {
            f2 = 0.325f;
        }
        if ((n4 & 0x80) != 0) {
            f3 = 0.15f;
        }
        renderUtil.renderRays(poseStack, f, vertexConsumer, n, n2, n3, f2, f3);
    }

    public final void renderLineThroughWalls(@NotNull PoseStack poseStack, @NotNull Vec3 start, @NotNull Vec3 end, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(AaronRenderTypes.INSTANCE.linesThroughWalls());
        PoseStack.Pose pose = poseStack.last();
        Vec3 normalVec = start.vectorTo(end).normalize();
        poseStack.pushPose();
        Intrinsics.checkNotNull((Object)pose);
        Intrinsics.checkNotNull((Object)vertexConsumer);
        RenderUtil.addVertex$default(this, pose, vertexConsumer, color, (float)start.x, (float)start.y, (float)start.z, 0.0f, 0.0f, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, 0, 0, 6144, null);
        RenderUtil.addVertex$default(this, pose, vertexConsumer, color, (float)end.x, (float)end.y, (float)end.z, 0.0f, 0.0f, (float)normalVec.x, (float)normalVec.y, (float)normalVec.z, 0, 0, 6144, null);
        poseStack.popPose();
    }

    public final void renderCubeThroughWalls(@NotNull PoseStack poseStack, @NotNull Vec3 center, float width, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        this.renderCubeThroughWalls(poseStack, center.x - (double)(width / (float)2), center.y - (double)(width / (float)2), center.z - (double)(width / (float)2), width, width, width, color);
    }

    public final void renderCubeThroughWalls(@NotNull PoseStack poseStack, @NotNull Number posX, @NotNull Number posY, @NotNull Number posZ, float width, float length, float height, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)posX, (String)"posX");
        Intrinsics.checkNotNullParameter((Object)posY, (String)"posY");
        Intrinsics.checkNotNullParameter((Object)posZ, (String)"posZ");
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(AaronRenderTypes.INSTANCE.quadsThroughWalls());
        poseStack.pushPose();
        poseStack.translate(posX.doubleValue(), posY.doubleValue(), posZ.doubleValue());
        for (Direction direction : EntriesMappings.entries$0) {
            PoseStack.Pose pose = poseStack.last();
            List<Vector3f> vertices = this.getVertices(direction, width, direction.getAxis().isVertical() ? length : height);
            for (Vector3f vertex : vertices) {
                Intrinsics.checkNotNull((Object)pose);
                Intrinsics.checkNotNull((Object)vertexConsumer);
                RenderUtil.addVertex$default(this, pose, vertexConsumer, color, vertex.x, vertex.y, vertex.z, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 7936, null);
            }
        }
        poseStack.popPose();
    }

    public final void renderTexturedCube(@NotNull PoseStack poseStack, @NotNull RenderType renderType, @NotNull ResourceLocation topTextureLocation, @NotNull ResourceLocation bottomTextureLocation, @NotNull ResourceLocation northTextureLocation, @NotNull ResourceLocation southTextureLocation, @NotNull ResourceLocation eastTextureLocation, @NotNull ResourceLocation westTextureLocation, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)renderType, (String)"renderType");
        Intrinsics.checkNotNullParameter((Object)topTextureLocation, (String)"topTextureLocation");
        Intrinsics.checkNotNullParameter((Object)bottomTextureLocation, (String)"bottomTextureLocation");
        Intrinsics.checkNotNullParameter((Object)northTextureLocation, (String)"northTextureLocation");
        Intrinsics.checkNotNullParameter((Object)southTextureLocation, (String)"southTextureLocation");
        Intrinsics.checkNotNullParameter((Object)eastTextureLocation, (String)"eastTextureLocation");
        Intrinsics.checkNotNullParameter((Object)westTextureLocation, (String)"westTextureLocation");
        Function textureAtlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite topSprite = (TextureAtlasSprite)textureAtlas.apply(topTextureLocation);
        TextureAtlasSprite bottomSprite = (TextureAtlasSprite)textureAtlas.apply(bottomTextureLocation);
        TextureAtlasSprite westSprite = (TextureAtlasSprite)textureAtlas.apply(westTextureLocation);
        TextureAtlasSprite eastSprite = (TextureAtlasSprite)textureAtlas.apply(eastTextureLocation);
        TextureAtlasSprite northSprite = (TextureAtlasSprite)textureAtlas.apply(northTextureLocation);
        TextureAtlasSprite southSprite = (TextureAtlasSprite)textureAtlas.apply(southTextureLocation);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Direction.UP, (Object)topSprite), TuplesKt.to((Object)Direction.DOWN, (Object)bottomSprite), TuplesKt.to((Object)Direction.WEST, (Object)westSprite), TuplesKt.to((Object)Direction.EAST, (Object)eastSprite), TuplesKt.to((Object)Direction.NORTH, (Object)northSprite), TuplesKt.to((Object)Direction.SOUTH, (Object)southSprite)};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType);
        PoseStack.Pose pose = poseStack.last();
        for (Map.Entry entry : map.entrySet()) {
            Direction direction = (Direction)entry.getKey();
            TextureAtlasSprite sprite = (TextureAtlasSprite)entry.getValue();
            if (direction == Direction.DOWN) continue;
            List<Vector3f> vertices = this.getVertices(direction, 1.0f, 1.0f);
            Iterator iterator = ((Iterable)vertices).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Vector3f vector = (Vector3f)iterator.next();
                float u = switch (index) {
                    case 0, 3 -> sprite.getU0();
                    default -> sprite.getU1();
                };
                float v = switch (index) {
                    case 0, 1 -> sprite.getV1();
                    default -> sprite.getV0();
                };
                Intrinsics.checkNotNull((Object)pose);
                Intrinsics.checkNotNull((Object)vertexConsumer);
                RenderUtil.addVertex$default(this, pose, vertexConsumer, -1, vector.x, vector.y, vector.z, u, v, 0.0f, 0.0f, 0.0f, light, overlay, 1792, null);
            }
        }
    }

    public static /* synthetic */ void renderTexturedCube$default(RenderUtil renderUtil, PoseStack poseStack, RenderType renderType, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, ResourceLocation resourceLocation3, ResourceLocation resourceLocation4, ResourceLocation resourceLocation5, ResourceLocation resourceLocation6, int n, int n2, int n3, Object object) {
        if ((n3 & 0x100) != 0) {
            n = 0xF000F0;
        }
        if ((n3 & 0x200) != 0) {
            n2 = OverlayTexture.NO_OVERLAY;
        }
        renderUtil.renderTexturedCube(poseStack, renderType, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, n, n2);
    }

    @NotNull
    public final List<Vector3f> getVertices(@NotNull Direction direction, float width, float length) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Vector3f bottomNorthWest = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f bottomNorthEast = new Vector3f(width, 0.0f, 0.0f);
        Vector3f bottomSouthWest = new Vector3f(0.0f, 0.0f, width);
        Vector3f bottomSouthEast = new Vector3f(width, 0.0f, width);
        Vector3f topNorthWest = new Vector3f(0.0f, length, 0.0f);
        Vector3f topNorthEast = new Vector3f(width, length, 0.0f);
        Vector3f topSouthWest = new Vector3f(0.0f, length, width);
        Vector3f topSouthEast = new Vector3f(width, length, width);
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                Object[] var12_12 = new Vector3f[]{topSouthWest, topSouthEast, topNorthEast, topNorthWest};
                yield CollectionsKt.listOf((Object[])var12_12);
            }
            case 2 -> {
                Object[] var12_13 = new Vector3f[]{bottomNorthWest, bottomNorthEast, bottomSouthEast, bottomSouthWest};
                yield CollectionsKt.listOf((Object[])var12_13);
            }
            case 3 -> {
                Object[] var12_14 = new Vector3f[]{bottomNorthEast, bottomNorthWest, topNorthWest, topNorthEast};
                yield CollectionsKt.listOf((Object[])var12_14);
            }
            case 4 -> {
                Object[] var12_15 = new Vector3f[]{bottomSouthWest, bottomSouthEast, topSouthEast, topSouthWest};
                yield CollectionsKt.listOf((Object[])var12_15);
            }
            case 5 -> {
                Object[] var12_16 = new Vector3f[]{bottomSouthEast, bottomNorthEast, topNorthEast, topSouthEast};
                yield CollectionsKt.listOf((Object[])var12_16);
            }
            case 6 -> {
                Object[] var12_17 = new Vector3f[]{bottomNorthWest, bottomSouthWest, topSouthWest, topNorthWest};
                yield CollectionsKt.listOf((Object[])var12_17);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void addVertex(@NotNull PoseStack.Pose pose, @NotNull VertexConsumer consumer, int color, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        consumer.addVertex(pose.pose(), x, y, z).setColor(color).setUv(u, v).setOverlay(overlay).setLight(light).setNormal(pose, normalX, normalY, normalZ);
    }

    public static /* synthetic */ void addVertex$default(RenderUtil renderUtil, PoseStack.Pose pose, VertexConsumer vertexConsumer, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x100) != 0) {
            f6 = 0.0f;
        }
        if ((n4 & 0x200) != 0) {
            f7 = 1.0f;
        }
        if ((n4 & 0x400) != 0) {
            f8 = 0.0f;
        }
        if ((n4 & 0x800) != 0) {
            n2 = 0xF000F0;
        }
        if ((n4 & 0x1000) != 0) {
            n3 = OverlayTexture.NO_OVERLAY;
        }
        renderUtil.addVertex(pose, vertexConsumer, n, f, f2, f3, f4, f5, f6, f7, f8, n2, n3);
    }

    public final void addVertex(@NotNull PoseStack.Pose pose, @NotNull VertexConsumer consumer, int color, float x, float y, float z, float u, float v, int u1, int v1, int u2, int v2, float normalX, float normalY, float normalZ) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        consumer.addVertex(pose.pose(), x, y, z).setColor(color).setUv(u, v).setUv1(u1, v1).setUv2(u2, v2).setNormal(pose, normalX, normalY, normalZ);
    }

    public static /* synthetic */ void addVertex$default(RenderUtil renderUtil, PoseStack.Pose pose, VertexConsumer vertexConsumer, int n, float f, float f2, float f3, float f4, float f5, int n2, int n3, int n4, int n5, float f6, float f7, float f8, int n6, Object object) {
        if ((n6 & 0x1000) != 0) {
            f6 = 0.0f;
        }
        if ((n6 & 0x2000) != 0) {
            f7 = 1.0f;
        }
        if ((n6 & 0x4000) != 0) {
            f8 = 0.0f;
        }
        renderUtil.addVertex(pose, vertexConsumer, n, f, f2, f3, f4, f5, n2, n3, n4, n5, f6, f7, f8);
    }

    public final int getColorFromFluid(@NotNull FluidStack fluidStack) {
        Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"fluidStack");
        IClientFluidTypeExtensions clientExt = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        int tintColor = clientExt.getTintColor(fluidStack);
        if (tintColor != -1) {
            return tintColor;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(clientExt.getStillTexture(fluidStack));
        Intrinsics.checkNotNull((Object)sprite);
        return this.getSpriteAverageColor(sprite);
    }

    public final int getSpriteAverageColor(@NotNull TextureAtlasSprite sprite) {
        Integer cachedColor;
        Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
        Integer n = cachedColor = SPRITE_AVERAGE_COLOR_CACHE.get(sprite);
        if (n != null) {
            return n;
        }
        NativeImage nativeImage = sprite.contents().getOriginalImage();
        int width = nativeImage.getWidth();
        int height = nativeImage.getHeight();
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int totalPixels = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = nativeImage.getPixelRGBA(x, y);
                int a = color & 0xFF;
                if (a <= 0) continue;
                int r = color >> 24 & 0xFF;
                int b = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                totalRed += r;
                totalGreen += g;
                totalBlue += b;
                ++totalPixels;
            }
        }
        if (totalPixels == 0) {
            return -1;
        }
        int averageRed = totalRed / totalPixels;
        int averageGreen = totalGreen / totalPixels;
        int averageBlue = totalBlue / totalPixels;
        int averageColor = 0xFF000000 | averageRed << 16 | averageGreen << 8 | averageBlue;
        Integer n2 = averageColor;
        SPRITE_AVERAGE_COLOR_CACHE.put(sprite, n2);
        return averageColor;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

