/*
 * Decompiled with CFR 0.152.
 */
package com.neuvillette.ae2ct.api;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.GenericStack;
import appeng.crafting.CraftingPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class RecipeHelper {
    public GenericStack output;
    public List<Recipe> recipes;

    public RecipeHelper(GenericStack output, List<Recipe> recipes) {
        this.output = output;
        this.recipes = recipes;
    }

    public static RecipeHelper fromCraftingPlan(CraftingPlan plan) {
        Map patternTimes = plan.patternTimes();
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        patternTimes.forEach((k, v) -> {
            IPatternDetails.IInput[] is = k.getInputs();
            ArrayList<GenericStack> inputs = new ArrayList<GenericStack>();
            List ouputs = k.getOutputs();
            for (IPatternDetails.IInput i : is) {
                GenericStack[] genericStacks = i.getPossibleInputs();
                long time = i.getMultiplier();
                GenericStack g = genericStacks[0];
                inputs.add(new GenericStack(g.what(), g.amount() * time));
            }
            recipes.add(new Recipe((List<GenericStack>)inputs, ouputs, (Long)v));
        });
        return new RecipeHelper(plan.finalOutput(), recipes);
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        GenericStack.writeBuffer((GenericStack)this.output, (RegistryFriendlyByteBuf)buffer);
        buffer.writeVarInt(this.recipes.size());
        for (Recipe r : this.recipes) {
            r.write(buffer);
        }
    }

    public static RecipeHelper read(RegistryFriendlyByteBuf buffer) {
        GenericStack output = GenericStack.readBuffer((RegistryFriendlyByteBuf)buffer);
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        int recipesSize = buffer.readVarInt();
        for (int i = 0; i < recipesSize; ++i) {
            recipes.add(Recipe.read(buffer));
        }
        return new RecipeHelper(output, recipes);
    }

    public record Recipe(List<GenericStack> inputs, List<GenericStack> outputs, Long times) {
        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(this.inputs.size());
            for (GenericStack i : this.inputs) {
                GenericStack.writeBuffer((GenericStack)i, (RegistryFriendlyByteBuf)buffer);
            }
            buffer.writeVarInt(this.outputs.size());
            for (GenericStack o : this.outputs) {
                GenericStack.writeBuffer((GenericStack)o, (RegistryFriendlyByteBuf)buffer);
            }
            buffer.writeVarLong(this.times.longValue());
        }

        public static Recipe read(RegistryFriendlyByteBuf buffer) {
            ArrayList<GenericStack> inputs = new ArrayList<GenericStack>();
            int inputsSize = buffer.readVarInt();
            for (int i = 0; i < inputsSize; ++i) {
                inputs.add(GenericStack.readBuffer((RegistryFriendlyByteBuf)buffer));
            }
            ArrayList<GenericStack> outputs = new ArrayList<GenericStack>();
            int outputsSize = buffer.readVarInt();
            for (int i = 0; i < outputsSize; ++i) {
                outputs.add(GenericStack.readBuffer((RegistryFriendlyByteBuf)buffer));
            }
            long times = buffer.readVarLong();
            return new Recipe(inputs, outputs, times);
        }
    }
}

