/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.ModPriorities;
import com.almostreliable.unified.api.unification.UnificationEntry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public final class ModPrioritiesImpl
implements ModPriorities {
    private final List<String> modPriorities;
    private final Map<TagKey<Item>, String> priorityOverrides;

    public ModPrioritiesImpl(List<String> modPriorities, Map<TagKey<Item>, String> priorityOverrides) {
        this.modPriorities = modPriorities;
        this.priorityOverrides = priorityOverrides;
    }

    @Override
    @Nullable
    public String getPriorityOverride(TagKey<Item> tag) {
        return this.priorityOverrides.get(tag);
    }

    @Override
    @Nullable
    public UnificationEntry<Item> findPriorityOverrideItem(TagKey<Item> tag, List<UnificationEntry<Item>> items) {
        String priorityOverride = this.getPriorityOverride(tag);
        if (priorityOverride == null) {
            return null;
        }
        UnificationEntry<Item> entry = ModPrioritiesImpl.findItemByNamespace(items, priorityOverride);
        if (entry != null) {
            return entry;
        }
        AlmostUnifiedCommon.LOGGER.warn("Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.", (Object)priorityOverride, (Object)tag.location());
        return null;
    }

    @Override
    @Nullable
    public UnificationEntry<Item> findTargetItem(TagKey<Item> tag, List<UnificationEntry<Item>> items) {
        UnificationEntry<Item> overrideEntry = this.findPriorityOverrideItem(tag, items);
        if (overrideEntry != null) {
            return overrideEntry;
        }
        for (String modPriority : this.modPriorities) {
            UnificationEntry<Item> entry = ModPrioritiesImpl.findItemByNamespace(items, modPriority);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return this.modPriorities.iterator();
    }

    @Nullable
    private static UnificationEntry<Item> findItemByNamespace(List<UnificationEntry<Item>> items, String namespace) {
        for (UnificationEntry<Item> item : items) {
            if (!item.id().getNamespace().equals(namespace)) continue;
            return item;
        }
        return null;
    }
}

