/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.ModPriorities;
import com.almostreliable.unified.api.unification.StoneVariants;
import com.almostreliable.unified.api.unification.TagSubstitutions;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.unification.UnificationEntryImpl;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public final class UnificationLookupImpl
implements UnificationLookup {
    private final ModPriorities modPriorities;
    private final StoneVariants stoneVariants;
    private final TagSubstitutions tagSubstitutions;
    private final Map<TagKey<Item>, Set<UnificationEntry<Item>>> tagsToEntries;
    private final Map<ResourceLocation, UnificationEntry<Item>> idsToEntries;

    private UnificationLookupImpl(ModPriorities modPriorities, StoneVariants stoneVariants, TagSubstitutions tagSubstitutions, Map<TagKey<Item>, Set<UnificationEntry<Item>>> tagsToEntries, Map<ResourceLocation, UnificationEntry<Item>> idsToEntries) {
        this.modPriorities = modPriorities;
        this.stoneVariants = stoneVariants;
        this.tagSubstitutions = tagSubstitutions;
        this.tagsToEntries = tagsToEntries;
        this.idsToEntries = idsToEntries;
    }

    @Override
    public Collection<TagKey<Item>> getTags() {
        return this.tagsToEntries.keySet();
    }

    @Override
    public Collection<UnificationEntry<Item>> getTagEntries(TagKey<Item> tag) {
        return this.tagsToEntries.getOrDefault(tag, Collections.emptySet());
    }

    @Override
    @Nullable
    public UnificationEntry<Item> getItemEntry(ResourceLocation item) {
        return this.idsToEntries.get(item);
    }

    @Override
    @Nullable
    public TagKey<Item> getRelevantItemTag(ResourceLocation item) {
        UnificationEntry<Item> entry = this.idsToEntries.get(item);
        return entry == null ? null : entry.tag();
    }

    @Override
    @Nullable
    public UnificationEntry<Item> getVariantItemTarget(ResourceLocation item) {
        TagKey<Item> tag = this.getRelevantItemTag(item);
        if (tag == null) {
            return null;
        }
        if (this.stoneVariants.isOreTag(tag)) {
            String stoneVariant = this.stoneVariants.getStoneVariant(item);
            return this.getTagTargetItem(tag, itemId -> stoneVariant.equals(this.stoneVariants.getStoneVariant((ResourceLocation)itemId)));
        }
        return this.getTagTargetItem(tag);
    }

    @Override
    @Nullable
    public UnificationEntry<Item> getTagTargetItem(TagKey<Item> tag, Predicate<ResourceLocation> itemFilter) {
        TagKey<Item> substituteTag = this.tagSubstitutions.getSubstituteTag(tag);
        TagKey<Item> tagToCheck = substituteTag != null ? substituteTag : tag;
        List<UnificationEntry<Item>> items = this.getTagEntries(tagToCheck).stream().filter(entry -> itemFilter.test(entry.id())).sorted(Comparator.comparingInt(value -> value.id().toString().length())).toList();
        return items.isEmpty() ? null : this.modPriorities.findTargetItem(tagToCheck, items);
    }

    @Override
    public boolean isUnifiedIngredientItem(Ingredient ingredient, ItemStack item) {
        HashSet<TagKey<Item>> checkedTags = new HashSet<TagKey<Item>>();
        for (ItemStack stack : ingredient.getItems()) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            TagKey<Item> relevantTag = this.getRelevantItemTag(itemId);
            if (relevantTag == null || checkedTags.contains(relevantTag)) continue;
            checkedTags.add(relevantTag);
            if (!item.is(relevantTag)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final Map<UnificationEntry<Item>, TagKey<Item>> entriesToTags = new HashMap<UnificationEntry<Item>, TagKey<Item>>();
        private final Map<TagKey<Item>, Set<UnificationEntry<Item>>> tagsToEntries = new HashMap<TagKey<Item>, Set<UnificationEntry<Item>>>();

        private void put(TagKey<Item> tag, UnificationEntry<Item> entry) {
            if (this.entriesToTags.containsKey(entry)) {
                TagKey<Item> boundTag = this.entriesToTags.get(entry);
                AlmostUnifiedCommon.LOGGER.error("Unification entry for item '{}' with tag '#{}' is already part of tag '#{}'.", (Object)entry.id(), (Object)tag.location(), (Object)boundTag.location());
                return;
            }
            this.entriesToTags.put(entry, tag);
            this.tagsToEntries.computeIfAbsent(tag, $ -> new HashSet()).add(entry);
        }

        public Builder put(TagKey<Item> tag, ResourceLocation ... ids) {
            for (ResourceLocation id : ids) {
                this.put(tag, new UnificationEntryImpl<ResourceLocation>((Registry<ResourceLocation>)BuiltInRegistries.ITEM, id));
            }
            return this;
        }

        public Builder put(TagKey<Item> tag, Item ... items) {
            for (Item item : items) {
                this.put(tag, new UnificationEntryImpl<Item>((Registry<Item>)BuiltInRegistries.ITEM, item));
            }
            return this;
        }

        public UnificationLookup build(ModPriorities modPriorities, StoneVariants stoneVariants, TagSubstitutions tagSubstitutions) {
            ImmutableMap.Builder tagsToEntriesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder idsToEntriesBuilder = ImmutableMap.builder();
            this.tagsToEntries.forEach((tag, entries) -> {
                ImmutableSet.Builder entrySetBuilder = ImmutableSet.builder();
                for (UnificationEntry entry : entries) {
                    entrySetBuilder.add((Object)entry);
                    ((UnificationEntryImpl)entry).bindTag(tag);
                    idsToEntriesBuilder.put((Object)entry.id(), (Object)entry);
                }
                tagsToEntriesBuilder.put(tag, (Object)entrySetBuilder.build());
            });
            return new UnificationLookupImpl(modPriorities, stoneVariants, tagSubstitutions, (Map<TagKey<Item>, Set<UnificationEntry<Item>>>)tagsToEntriesBuilder.build(), (Map<ResourceLocation, UnificationEntry<Item>>)idsToEntriesBuilder.build());
        }
    }
}

