/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.client.BlockScanner;
import net.mehvahdjukaar.amendments.client.WallLanternModelsManager;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.mixins.SignRendererAccessor;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.Nullable;

public class ClientResourceGenerator
extends DynamicClientResourceProvider {
    public ClientResourceGenerator() {
        super(Amendments.res("generated_pack"), PackGenerationStrategy.CACHED);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("minecraft");
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
            PlatHelper.getInstalledMods().forEach(namespaces::add);
        }
        return namespaces;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        WallLanternModelsManager.refreshModels(Minecraft.getInstance().getResourceManager());
        if (ClientConfigs.JUKEBOX_MODEL.get().booleanValue()) {
            executor.accept(this::generateJukeboxAssets);
        }
        if (CommonConfigs.DOUBLE_CAKES.get().booleanValue()) {
            executor.accept(this::generateDoubleCakesAssets);
        }
        if (ClientConfigs.SIGN_ATTACHMENT.get().booleanValue()) {
            executor.accept(this::generateHangingSignAssets);
        }
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
            executor.accept(this::generateSignTextures);
            if (CompatHandler.FARMERS_DELIGHT) {
                executor.accept(this::generateFdSignTextures);
            }
            executor.accept(this::generateSignBlockModels);
        }
        executor.accept((manager, sink) -> {
            if (ClientConfigs.COLORED_ARROWS.get().booleanValue()) {
                sink.addItemModel(ResourceLocation.withDefaultNamespace((String)"crossbow_arrow"), JsonParser.parseString((String)"{\n    \"parent\": \"item/crossbow\",\n    \"textures\": {\n        \"layer0\": \"item/crossbow_arrow_base\",\n        \"layer1\": \"item/crossbow_arrow_tip\"\n    }\n}\n"));
            }
            if (ClientConfigs.JUKEBOX_MODEL.get().booleanValue()) {
                sink.addItemModel(ResourceLocation.withDefaultNamespace((String)"jukebox"), JsonParser.parseString((String)"{\n  \"parent\": \"amendments:block/jukebox\"\n}\n"));
                sink.addBlockState(ResourceLocation.withDefaultNamespace((String)"jukebox"), JsonParser.parseString((String)"{\n  \"variants\": {\n    \"has_record=true\": {\n      \"model\": \"amendments:block/jukebox_on\"\n    },\n    \"has_record=false\": {\n      \"model\": \"amendments:block/jukebox\"\n    }\n  }\n}\n"));
            }
        });
    }

    private void generateSignTextures(ResourceManager manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)64, (int)32, (int)64, (int)16).copyFrom(0, 16, 8, 16).to(56, 0).build();
        try (TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Amendments.res("block/signs/template"));
             TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Amendments.res("block/signs/mask"));){
            Respriter respriter = Respriter.masked((TextureImage)template, (TextureImage)mask);
            for (net.mehvahdjukaar.moonlight.api.set.wood.WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                Block sing = w.getBlockOfThis("sign");
                if (sing == null) continue;
                ResourceLocation blockLocation = Amendments.res("block/signs/" + w.getVariantId("sign"));
                ResourceLocation signTextureLocation = ClientResourceGenerator.findSignTexture(manager, w, sing, false);
                if (signTextureLocation == null) continue;
                sink.addTextureIfNotPresent(manager, blockLocation, () -> {
                    try (TextureImage signTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)signTextureLocation);){
                        TextureImage textureImage;
                        block15: {
                            TextureImage modPlankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)w.planks));
                            try {
                                List palette = Palette.fromAnimatedImage((TextureImage)modPlankTexture);
                                for (Palette p : palette) {
                                    p.remove(p.getLightest());
                                }
                                TextureImage newImage = respriter.recolorWithAnimation(palette, modPlankTexture.getMcMeta());
                                transformer.apply(signTexture, newImage);
                                textureImage = newImage;
                                if (modPlankTexture == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (modPlankTexture != null) {
                                    try {
                                        modPlankTexture.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            modPlankTexture.close();
                        }
                        return textureImage;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (Exception e) {
            Amendments.LOGGER.warn("Failed to generate sign extension textures, ", (Throwable)e);
        }
    }

    @Nullable
    private static ResourceLocation findSignTexture(ResourceManager manager, net.mehvahdjukaar.moonlight.api.set.wood.WoodType w, Block sing, boolean hanging) {
        Material signMaterial;
        WoodType vanilla = w.toVanilla();
        if (vanilla == null) {
            Amendments.LOGGER.error("Vanilla wood type for wood {} was null. This is a bug", (Object)w);
            return null;
        }
        Material material = signMaterial = hanging ? Sheets.getHangingSignMaterial((WoodType)vanilla) : Sheets.getSignMaterial((WoodType)vanilla);
        if (signMaterial == null) {
            try {
                BlockEntity be = ((EntityBlock)sing).newBlockEntity(BlockPos.ZERO, sing.defaultBlockState());
                BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
                if (renderer instanceof SignRendererAccessor) {
                    SignRendererAccessor sr = (SignRendererAccessor)renderer;
                    signMaterial = sr.invokeGetSignMaterial(vanilla);
                }
            }
            catch (Exception e) {
                Amendments.LOGGER.error("Failed to get sign material for wood (from block entity renderer) {}, ", (Object)w, (Object)e);
            }
        }
        if (signMaterial == null) {
            ResourceLocation relativeLocation = w.getId().withPrefix("entity/signs/" + (hanging ? "hanging/" : ""));
            ResourceLocation id = ResType.TEXTURES.getPath(relativeLocation);
            if (manager.getResource(id).isPresent()) {
                return relativeLocation;
            }
        } else {
            return signMaterial.texture();
        }
        Amendments.LOGGER.error("Sign material for wood {} was null. This is likely due to some mod calling Sheets.getSignMaterial too early or by some wood mod not registering their wood type properly by not adding it to the vanilla texture map. Sheets.getSignMaterial is NOT Nullable, i shouldn't even have this check.", (Object)w);
        return null;
    }

    private static String joinNonEmpty(String first, String second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        return first + "_" + second;
    }

    private void generateFdSignTextures(ResourceManager manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)64, (int)32, (int)64, (int)16).copyFrom(0, 16, 8, 16).to(56, 0).copyFrom(0, 0, 32, 11).to(0, 0).copyFrom(0, 12, 28, 2).to(0, 9).copyFrom(26, 2, 2, 14).to(18, 2).copyFrom(24, 7, 2, 10).to(16, 4).copyFrom(23, 2, 3, 3).to(15, 2).copyFrom(28, 2, 24, 12).to(20, 2).copyFrom(28, 12, 24, 2).to(20, 9).copyFrom(50, 2, 2, 8).to(34, 2).build();
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(DyeColor.values()).forEach(d -> names.add(d.getName()));
        names.add("");
        for (String d2 : names) {
            ResourceLocation texturePath = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)ClientResourceGenerator.joinNonEmpty("entity/signs/canvas", d2));
            ResourceLocation blockTexturePath = Amendments.res("block/signs/farmersdelight/" + ClientResourceGenerator.joinNonEmpty(d2, "canvas_sign"));
            sink.addTextureIfNotPresent(manager, blockTexturePath, () -> {
                TextureImage textureImage;
                block8: {
                    TextureImage vanillaTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)texturePath);
                    try {
                        TextureImage newImg = TextureImage.createNew((int)64, (int)16);
                        transformer.apply(vanillaTexture, newImg);
                        textureImage = newImg;
                        if (vanillaTexture == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (vanillaTexture != null) {
                                try {
                                    vanillaTexture.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    vanillaTexture.close();
                }
                return textureImage;
            });
        }
    }

    private void generateSignBlockModels(ResourceManager manager, ResourceSink sink) {
        AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.clear();
        StaticResource sign0 = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_0")));
        StaticResource sign1 = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_1")));
        StaticResource sign2 = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_2")));
        StaticResource sign3 = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_3")));
        StaticResource signWall = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Amendments.res("signs/sign_oak_wall")));
        StaticResource blockState = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Amendments.res("sign_oak")));
        StaticResource blockStateWall = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Amendments.res("sign_oak_wall")));
        String blockStateText = new String(blockState.data, StandardCharsets.UTF_8);
        String blockStateWallText = new String(blockStateWall.data, StandardCharsets.UTF_8);
        for (net.mehvahdjukaar.moonlight.api.set.wood.WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
            Block sign = w.getBlockOfThis("sign");
            Block wallSign = w.getBlockOfThis("wall_sign");
            if (sign == null || wallSign == null) continue;
            String variantId = w.getVariantId("sign");
            sink.addSimilarJsonResource(manager, sign0, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, sign1, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, sign2, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, sign3, "sign_oak", variantId);
            sink.addSimilarJsonResource(manager, signWall, "sign_oak", variantId);
            sink.addBytes(Utils.getID((Block)sign), blockStateText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
            sink.addBytes(Utils.getID((Block)wallSign), blockStateWallText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
            AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(sign);
            AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(wallSign);
        }
        ArrayList<String> names = new ArrayList<String>();
        Arrays.stream(DyeColor.values()).forEach(d -> names.add(d.getName() + "_"));
        names.add("");
        if (CompatHandler.FARMERS_DELIGHT) {
            for (Block canvas : BlockScanner.getInstance().getFdSigns()) {
                ResourceLocation id = Utils.getID((Block)canvas);
                Block canvasWall = BuiltInRegistries.BLOCK.getOptional(id.withPath(p -> p.replace("sign", "wall_sign"))).orElse(null);
                if (canvasWall == null) continue;
                ResourceLocation canvasWallId = Utils.getID((Block)canvasWall);
                String variantId = "farmersdelight/" + id.getPath();
                sink.addSimilarJsonResource(manager, sign0, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, sign1, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, sign2, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, sign3, "sign_oak", variantId);
                sink.addSimilarJsonResource(manager, signWall, "sign_oak", variantId);
                sink.addBytes(id, blockStateText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
                sink.addBytes(canvasWallId, blockStateWallText.replace("sign_oak", variantId).getBytes(), ResType.BLOCKSTATES);
                AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(canvas);
                AmendmentsClient.SIGN_THAT_WE_RENDER_AS_BLOCKS.add(canvasWall);
            }
        }
    }

    private void generateHangingSignAssets(ResourceManager manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)32, (int)64, (int)16, (int)16).copyFrom(26, 0, 2, 4).to(4, 0).copyFrom(26, 8, 6, 8).to(4, 4).copyFrom(28, 24, 4, 8).to(0, 4).copyFrom(26, 20, 2, 4).to(6, 0).copyFrom(26, 28, 2, 8).to(10, 4).flippedX().build();
        for (net.mehvahdjukaar.moonlight.api.set.wood.WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
            ResourceLocation signTexturePath;
            Block hangingSign = w.getBlockOfThis("hanging_sign");
            if (hangingSign == null || (signTexturePath = ClientResourceGenerator.findSignTexture(manager, w, hangingSign, true)) == null) continue;
            try {
                TextureImage vanillaTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)signTexturePath);
                try {
                    TextureImage rotated = TextureOps.createRotated((TextureImage)vanillaTexture, (Rotation)Rotation.CLOCKWISE_90);
                    try {
                        TextureImage newIm = TextureOps.createScaled((TextureImage)vanillaTexture, (float)0.25f, (float)0.5f);
                        try {
                            newIm.clear();
                            transformer.apply(rotated, newIm);
                            sink.addTexture(Amendments.res("entity/signs/hanging/" + w.getVariantId("extension")), newIm);
                        }
                        finally {
                            if (newIm == null) continue;
                            newIm.close();
                        }
                    }
                    finally {
                        if (rotated == null) continue;
                        rotated.close();
                    }
                }
                finally {
                    if (vanillaTexture == null) continue;
                    vanillaTexture.close();
                }
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)w, (Object)e);
            }
        }
        if (CompatHandler.FARMERS_DELIGHT) {
            try (TextureImage vanillaTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"entity/signs/hanging/canvas"));
                 TextureImage rotated = TextureOps.createRotated((TextureImage)vanillaTexture, (Rotation)Rotation.CLOCKWISE_90);
                 TextureImage newIm = TextureOps.createScaled((TextureImage)rotated, (float)0.5f, (float)0.25f);){
                newIm.clear();
                transformer.apply(rotated, newIm);
                sink.addTexture(Amendments.res("entity/signs/hanging/farmersdelight/extension_canvas"), newIm);
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)"canvas sign", (Object)e);
            }
        }
    }

    private void generateJukeboxAssets(ResourceManager manager, ResourceSink sink) {
        TextureCollager transformer = TextureCollager.builder((int)16, (int)16, (int)16, (int)16).copyFrom(5, 6, 3, 2).to(6, 6).copyFrom(8, 6, 1, 1).to(9, 7).copyFrom(7, 7, 3, 2).to(7, 8).copyFrom(6, 8, 1, 1).to(6, 8).copyFrom(9, 6, 1, 1).to(9, 6).copyFrom(5, 8, 1, 1).to(6, 9).build();
        try (TextureImage fallback = TextureImage.open((ResourceManager)manager, (ResourceLocation)Amendments.res("block/music_discs/music_disc_generic"));
             TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Amendments.res("block/music_discs/music_disc_template"));
             TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Amendments.res("block/music_discs/music_disc_mask"));){
            Respriter respriter = Respriter.of((TextureImage)template);
            for (Map.Entry<Item, Material> e : AmendmentsClient.getAllRecords().entrySet()) {
                ResourceLocation texturePath = Amendments.res(e.getValue().texture().getPath());
                if (sink.alreadyHasTextureAtLocation(manager, texturePath)) continue;
                try {
                    TextureImage vanillaTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)e.getKey()));
                    try {
                        Palette p = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)mask);
                        ClientResourceGenerator.amendJukeboxPalette(p);
                        TextureImage newImage = respriter.recolor(p);
                        try {
                            transformer.apply(vanillaTexture, newImage);
                            if (newImage.getPixel(6, 6) == p.get(p.size() - 2).rgb().toInt()) {
                                newImage.setPixel(6, 6, p.getLightest().value());
                                newImage.setPixel(9, 9, p.getLightest().value());
                            }
                            sink.addTexture(texturePath, newImage);
                        }
                        finally {
                            if (newImage == null) continue;
                            newImage.close();
                        }
                    }
                    finally {
                        if (vanillaTexture == null) continue;
                        vanillaTexture.close();
                    }
                }
                catch (Exception ex) {
                    Amendments.LOGGER.warn("Failed to generate record item texture for {}. No model / texture found", (Object)e.getKey());
                    sink.addTexture(texturePath, fallback);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void amendJukeboxPalette(Palette p) {
        float averLum = p.getAverageLuminanceStep();
        if ((double)averLum > 0.06) {
            p.increaseInner();
        }
        PaletteColor darkest = p.getDarkest();
        PaletteColor beforeDarkest = p.get(1);
        if ((double)(beforeDarkest.luminance() - darkest.luminance()) > (double)averLum - 0.005) {
            p.remove(darkest);
            p.increaseDown();
        }
    }

    private void generateDoubleCakesAssets(ResourceManager manager, ResourceSink sink) {
        StaticResource[] cakeModels = (StaticResource[])Stream.of("full", "slice1", "slice2", "slice3", "slice4", "slice5", "slice6").map(s -> StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Amendments.res("double_cake/vanilla_" + s)))).toArray(StaticResource[]::new);
        StaticResource doubleCakeModelState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Amendments.res("double_cake")));
        for (CakeRegistry.CakeType t : CakeRegistry.INSTANCE.getValues()) {
            if (t.isVanilla()) continue;
            try {
                ResourceLocation dcId = Utils.getID((Block)t.getBlockOfThis("double_cake"));
                ResourceLocation top = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("top"));
                ResourceLocation side = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("side"));
                ResourceLocation bottom = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("bottom"));
                ResourceLocation inner = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("inner"));
                for (StaticResource m : cakeModels) {
                    sink.addSimilarJsonResource(manager, m, s -> s.replace("amendments:block/double_cake", "").replace("minecraft:block/cake", "").replace("\"/", "\"amendments:block/double_cake/").replace("_top", top.toString()).replace("_side", side.toString()).replace("_inner", inner.toString()).replace("_bottom", bottom.toString()), s -> s.replace("vanilla", dcId.getPath()));
                }
                sink.addSimilarJsonResource(manager, doubleCakeModelState, s -> s.replace("vanilla", dcId.getPath()), s -> s.replace("double_cake", dcId.getPath()));
            }
            catch (Exception e) {
                Amendments.LOGGER.error("Failed to generate model for double cake {},", (Object)t);
            }
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent languageEvent) {
        if (languageEvent.isDefault()) {
            languageEvent.addEntry("item.minecraft.lingering_potion.effect.empty", "Lingering Mixed Potion");
            languageEvent.addEntry("item.minecraft.splash_potion.effect.empty", "Splash Mixed Potion");
            languageEvent.addEntry("item.minecraft.potion.effect.empty", "Mixed Potion");
        }
    }
}

