/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.LecternEditMenu;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.TextFilter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;

public class ServerBoundSyncLecternBookMessage
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSyncLecternBookMessage> TYPE = Message.makeType((ResourceLocation)Amendments.res("server_bound_sync_lectern_book"), ServerBoundSyncLecternBookMessage::new);
    private final List<String> pages;
    private final Optional<String> title;
    private final BlockPos pos;
    private final boolean takeBook;

    public ServerBoundSyncLecternBookMessage(BlockPos pos, List<String> list, Optional<String> optional, boolean takeBook) {
        this.pos = pos;
        this.pages = ImmutableList.copyOf(list);
        this.title = optional;
        this.takeBook = takeBook;
    }

    public ServerBoundSyncLecternBookMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.pages = (List)buffer.readCollection(FriendlyByteBuf.limitValue(Lists::newArrayListWithCapacity, (int)200), b -> b.readUtf(8192));
        this.title = buffer.readOptional(b -> b.readUtf(128));
        this.takeBook = buffer.readBoolean();
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeCollection(this.pages, (friendlyByteBuf, string) -> friendlyByteBuf.writeUtf(string, 8192));
        buffer.writeOptional(this.title, (friendlyByteBuf, string) -> friendlyByteBuf.writeUtf(string, 128));
        buffer.writeBoolean(this.takeBook);
    }

    public void handle(Message.Context context) {
        LecternBlockEntity be;
        ItemStack book;
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof LecternBlockEntity && (book = (be = (LecternBlockEntity)blockEntity).getBook()).getItem() instanceof WritableBookItem) {
            ArrayList list = Lists.newArrayList();
            Objects.requireNonNull(list);
            this.title.ifPresent(list::add);
            Stream limit = this.pages.stream().limit(100L);
            Objects.requireNonNull(list);
            limit.forEach(list::add);
            Consumer<List> consumer = this.title.isPresent() ? l -> this.signBook(be, player, book, (FilteredText)l.get(0), l.subList(1, l.size())) : l -> this.updateBookContents(be, player, book, (List<FilteredText>)l);
            this.filterTextPacket(player, list, TextFilter::processMessageBundle).thenAcceptAsync(consumer, (Executor)level.getServer());
        }
    }

    private <T, R> CompletableFuture<R> filterTextPacket(ServerPlayer player, T message, BiFunction<TextFilter, T, CompletableFuture<R>> processor) {
        return processor.apply(player.getTextFilter(), (TextFilter)message).thenApply(object -> {
            if (!player.connection.isAcceptingMessages()) {
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private void updateBookContents(LecternBlockEntity be, ServerPlayer player, ItemStack itemstack, List<FilteredText> pages) {
        AbstractContainerMenu abstractContainerMenu;
        if (itemstack.is(Items.WRITABLE_BOOK)) {
            List<Filterable> list = pages.stream().map(t -> this.filterableFromOutgoing((FilteredText)t, player)).toList();
            itemstack.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)new WritableBookContent(list));
            be.setChanged();
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        }
        if (this.takeBook && (abstractContainerMenu = player.containerMenu) instanceof LecternEditMenu) {
            LecternEditMenu m = (LecternEditMenu)abstractContainerMenu;
            m.clickMenuButton((Player)player, 3);
        }
    }

    private void signBook(LecternBlockEntity be, ServerPlayer player, ItemStack book, FilteredText title, List<FilteredText> pages) {
        AbstractContainerMenu abstractContainerMenu;
        ItemStack signedBook = book.transmuteCopy((ItemLike)Items.WRITTEN_BOOK);
        signedBook.remove(DataComponents.WRITABLE_BOOK_CONTENT);
        List<Filterable> filteredPages = pages.stream().map(t -> this.filterableFromOutgoing((FilteredText)t, player).map(s -> Component.literal((String)s))).toList();
        signedBook.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(this.filterableFromOutgoing(title, player), player.getName().getString(), 0, filteredPages, true));
        be.setBook(signedBook);
        be.setChanged();
        player.level().sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
        if (this.takeBook && (abstractContainerMenu = player.containerMenu) instanceof LecternEditMenu) {
            LecternEditMenu m = (LecternEditMenu)abstractContainerMenu;
            m.clickMenuButton((Player)player, 3);
        }
    }

    private Filterable<String> filterableFromOutgoing(FilteredText filteredText, ServerPlayer player) {
        return player.isTextFilteringEnabled() ? Filterable.passThrough((Object)filteredText.filteredOrEmpty()) : Filterable.from((FilteredText)filteredText);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

