/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.affix.create;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.DamageSourceExtension;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import ianm1647.apothic_compats.loot.ModLootCategories;
import java.util.Set;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;

public class MagicalPotatoAffix
extends Affix {
    public static final Codec<MagicalPotatoAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(MagicalPotatoAffix.affixDef(), (App)PlaceboCodecs.setOf((Codec)LootRarity.CODEC).fieldOf("rarities").forGetter(a -> a.rarities)).apply((Applicative)inst, MagicalPotatoAffix::new));
    protected Set<LootRarity> rarities;

    public MagicalPotatoAffix(AffixDefinition def, Set<LootRarity> rarities) {
        super(def);
        this.rarities = rarities;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return ModLootCategories.isPotatoCannon(cat) && this.rarities.contains(rarity);
    }

    public static void modifyIncomingDamageTags(EntityInvulnerabilityCheckEvent e) {
        PotatoProjectileEntity dart;
        Entity var2 = e.getSource().getDirectEntity();
        if (var2 instanceof PotatoProjectileEntity && AffixHelper.streamAffixes((Projectile)(dart = (PotatoProjectileEntity)var2)).anyMatch(a -> a.getAffix() instanceof MagicalPotatoAffix)) {
            DamageSourceExtension ext = (DamageSourceExtension)e.getSource();
            ext.addTag(Tags.DamageTypes.IS_MAGIC);
            ext.addTag(DamageTypeTags.BYPASSES_ARMOR);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

