/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.affix.malum;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.effect.CleavingAffix;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.DamageSourceExtension;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.apothic_compats.loot.ModLootCategories;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class ScytheThunderstruckAffix
extends Affix {
    public static final Codec<ScytheThunderstruckAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(ScytheThunderstruckAffix.affixDef(), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories), (App)LootRarity.mapCodec((Codec)StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ScytheThunderstruckAffix::new));
    protected final Set<LootCategory> categories;
    protected final Map<LootRarity, StepFunction> values;

    public ScytheThunderstruckAffix(AffixDefinition def, Set<LootCategory> categories, Map<LootRarity, StepFunction> values) {
        super(def);
        this.categories = categories;
        this.values = values;
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{ScytheThunderstruckAffix.fmt((float)this.getTrueLevel(inst.getRarity(), inst.level()))});
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        LootRarity rarity = inst.getRarity();
        MutableComponent minComp = Component.literal((String)ScytheThunderstruckAffix.fmt((float)this.getTrueLevel(rarity, 0.0f)));
        MutableComponent maxComp = Component.literal((String)ScytheThunderstruckAffix.fmt((float)this.getTrueLevel(rarity, 1.0f)));
        return comp.append((Component)ScytheThunderstruckAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return ModLootCategories.isScythe(cat) && this.values.containsKey(rarity);
    }

    public void doPostAttack(AffixInstance inst, LivingEntity user, Entity target) {
        if (user.level().isClientSide) {
            return;
        }
        if ((double)ApothicAttributes.getLocalAtkStrength((Entity)user) >= 0.98) {
            List nearby = target.level().getEntities(target, new AABB(target.blockPosition()).inflate(6.0), (Predicate)CleavingAffix.cleavePredicate((Entity)user, (Entity)target));
            for (Entity e : nearby) {
                DamageSource src = user.damageSources().mobAttack(user);
                ((DamageSourceExtension)src).addTag(DamageTypeTags.IS_LIGHTNING);
                ((DamageSourceExtension)src).addTag(DamageTypeTags.BYPASSES_ARMOR);
                e.hurt(src, this.getTrueLevel(inst.getRarity(), inst.level()));
            }
        }
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

