/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.deep_aether;

import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import io.github.razordevs.deep_aether.init.DAItems;
import io.github.razordevs.deep_aether.init.DATiers;
import io.github.razordevs.deep_aether.item.gear.DAArmorMaterials;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class DeepAetherAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "deep_aether";
    private static ResourceKey<Level> AETHER = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"aether:the_aether"));
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights SKYJADE = TieredWeights.builder().with(WorldTier.ASCENT, 5, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights STRATUS = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 0.0f).with(WorldTier.PINNACLE, 10, 0.0f).build();
    protected static final TieredWeights STORMFORGED = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 0.0f).with(WorldTier.PINNACLE, 10, 0.0f).build();

    public DeepAetherAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.armorWeights.put((Holder<ArmorMaterial>)DAArmorMaterials.SKYJADE, SKYJADE);
        this.armorWeights.put((Holder<ArmorMaterial>)DAArmorMaterials.STRATUS, STRATUS);
        this.armorWeights.put((Holder<ArmorMaterial>)DAArmorMaterials.STORMFORGED, STORMFORGED);
        this.toolWeights.put((Tier)DATiers.SKYJADE, SKYJADE);
        this.toolWeights.put((Tier)DATiers.STRATUS, STRATUS);
        this.toolWeights.put((Tier)DATiers.STORM, STORMFORGED);
        this.addEntry(STORMFORGED, DAItems.STORM_BOW.toStack());
        for (Item i : BuiltInRegistries.ITEM) {
            Item t;
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!this.mod.equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem((ItemStack)i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t2 = (TieredItem)i;
                weights = this.toolWeights.get(t2.getTier());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (i instanceof ArmorItem && (a = (ArmorItem)i).getType() != ArmorItem.Type.BODY) {
                weights = this.armorWeights.get(a.getMaterial());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (!(i instanceof Item) || (weights = this.itemWeights.get(t = i)) == null) continue;
            this.addEntry(weights, new ItemStack((ItemLike)i));
        }
    }

    public String getName() {
        return "Deep Aether Affix Loot Entries";
    }

    protected void addEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension(AETHER), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

