/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.eternal_starlight;

import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class StarlightInvaderProvider
extends InvaderProvider {
    String mod = "eternal_starlight";
    private static ResourceKey<Level> STARLIGHT = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"eternal_starlight:starlight"));

    public StarlightInvaderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Eternal Starlight Invaders";
    }

    public void generate() {
        this.addBoss("boarwarf", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.BOARWARF.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("astral_golem", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.ASTRAL_GOLEM.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("lonestar_skeleton", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.LONESTAR_SKELETON.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("nightfall_spider", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.NIGHTFALL_SPIDER.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("thirst_walker", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.THIRST_WALKER.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("creteor", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.CRETEOR.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("freeze", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.FREEZE.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addBoss("tangled", b -> StarlightInvaderProvider.basicMeleeStats((Invader.Builder)b).entity((EntityType)ESEntities.TANGLED.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.ASCENT, (int)100, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("thirst_walker", b -> StarlightInvaderProvider.ancientMeleeStats(b).entity((EntityType)ESEntities.THIRST_WALKER.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("creteor", b -> StarlightInvaderProvider.ancientMeleeStats(b).entity((EntityType)ESEntities.CRETEOR.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("astral_golem", b -> StarlightInvaderProvider.ancientMeleeStats(b).entity((EntityType)ESEntities.ASTRAL_GOLEM.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("lonestar_skeleton", b -> StarlightInvaderProvider.ancientMeleeStats(b).entity((EntityType)ESEntities.LONESTAR_SKELETON.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
        this.addAncientBoss("tangled", b -> StarlightInvaderProvider.ancientMeleeStats(b).entity((EntityType)ESEntities.TANGLED.get()).basicData(c -> StarlightInvaderProvider.meleeGear((BasicBossData.Builder)c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove((WorldTier)WorldTier.PINNACLE, (int)10, (float)0.1f)).constraints(Constraints.forDimension(STARLIGHT)).bonusLoot(new ResourceKey[]{Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS})));
    }

    protected static Invader.Builder ancientMeleeStats(Invader.Builder builder) {
        LootRarity ancient = StarlightInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.8f, 1.5f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.2f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected static Invader.Builder ancientRangedStats(Invader.Builder builder) {
        LootRarity ancient = StarlightInvaderProvider.ancientRarity("ancient");
        return builder.stats(ancient, c -> c.enchantChance(0.95f).enchLevels(40, 30).effect(1.0f, MobEffects.FIRE_RESISTANCE).modifier(Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 220.0f, 450.0f).modifier(Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.5f, 0.8f).modifier(ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.9f, 1.8f).modifier(Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.0f)).modifier(Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier(Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)25.0f)).modifier(Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected void addBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(ApothicCompats.loc(this.mod + "/" + name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).size(1.0, 1.0).build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    protected void addAncientBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.addConditionally(ApothicCompats.loc(this.mod + "/ancient/" + name), (CodecProvider)((Invader.Builder)builder.apply(Invader.builder())).size(1.0, 1.0).build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

