/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.farmersdelight;

import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FarmersDelightAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "farmersdelight";
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights FLINT = TieredWeights.onlyFor((WorldTier)WorldTier.HAVEN, (int)25, (float)0.0f);
    protected static final TieredWeights GOLD = TieredWeights.builder().with(WorldTier.HAVEN, 5, 0.0f).with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 5, 0.0f).build();
    protected static final TieredWeights IRON = TieredWeights.builder().with(WorldTier.FRONTIER, 25, 1.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights DIAMOND = TieredWeights.builder().with(WorldTier.ASCENT, 25, 0.0f).with(WorldTier.SUMMIT, 25, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();
    protected static final TieredWeights NETHERITE = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 1.0f).with(WorldTier.PINNACLE, 25, 2.0f).build();

    public FarmersDelightAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.addEntry(IRON, new ItemStack((ItemLike)ModItems.IRON_KNIFE.get()));
        this.addEntry(DIAMOND, new ItemStack((ItemLike)ModItems.DIAMOND_KNIFE.get()));
        this.addNetherEntry(DIAMOND, new ItemStack((ItemLike)ModItems.DIAMOND_KNIFE.get()));
        this.addNetherEntry(NETHERITE, new ItemStack((ItemLike)ModItems.NETHERITE_KNIFE.get()));
    }

    public String getName() {
        return "Farmers Delight Affix Loot Entries";
    }

    protected void addEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension((ResourceKey)Level.OVERWORLD), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    protected void addNetherEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/nether/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension((ResourceKey)Level.NETHER), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

