/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.block.entity;

import appeng.api.config.FuzzyMode;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import es.degrassi.appexp.block.ExperienceConverterBlock;
import es.degrassi.appexp.definition.AExpBlockEntities;
import es.degrassi.appexp.definition.AExpBlocks;
import es.degrassi.appexp.definition.AExpComponents;
import es.degrassi.appexp.definition.AExpConfig;
import es.degrassi.appexp.definition.AExpMenus;
import es.degrassi.appexp.definition.AExpTags;
import es.degrassi.appexp.util.inv.filter.ApexItemFilters;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.impl.capability.BasicExperienceHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExperienceConverterEntity
extends BlockEntity
implements ServerTickingBlockEntity,
IActionHost,
InternalInventoryHost {
    private final BasicExperienceHandler experienceTank;
    private final AppEngInternalInventory inventoryIn;
    private final AppEngInternalInventory inventoryOut;
    private final CombinedInternalInventory internalInventory;
    private final FluidTank fluidTank;
    private boolean setChangedQueued;

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(ExperienceLibCapabilities.EXPERIENCE.block(), AExpBlockEntities.EXPERIENCE_CONVERTER.get(), (be, ctx) -> be.experienceTank);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, AExpBlockEntities.EXPERIENCE_CONVERTER.get(), (be, ctx) -> be.fluidTank);
        event.registerItem(ExperienceLibCapabilities.EXPERIENCE.item(), (item, v) -> {
            BasicExperienceHandler handler = new BasicExperienceHandler(1, Long.MAX_VALUE, null);
            handler.setExperience(0, Optional.ofNullable((Long)item.get(AExpComponents.EXPERIENCE_AMOUNT)).orElse(0L).longValue());
            return handler;
        }, new ItemLike[]{AExpBlocks.EXPERIENCE_CONVERTER.item().get()});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, AExpBlockEntities.EXPERIENCE_CONVERTER.get(), (be, ctx) -> be.internalInventory.toItemHandler());
    }

    public float getFillState() {
        return (float)this.getExperience() / (float)this.getExperienceCapacity();
    }

    public ExperienceConverterEntity(BlockPos pos, BlockState blockState) {
        super(AExpBlockEntities.EXPERIENCE_CONVERTER.get(), pos, blockState);
        this.experienceTank = new BasicExperienceHandler(1, ((Long)AExpConfig.get().XP_CONVERTER_CAPACITY.get()).longValue(), () -> {
            CompoundTag tag = new CompoundTag();
            this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
            BlockState state = (BlockState)this.getBlockState().setValue((Property)ExperienceConverterBlock.light, (Comparable)Integer.valueOf(Mth.lerpInt((float)Mth.clamp((float)((float)this.getExperience() / (float)this.getExperienceCapacity()), (float)0.0f, (float)1.0f), (int)0, (int)15)));
            this.level.setBlockAndUpdate(this.getBlockPos(), state);
            BlockEntity patt0$temp = this.level.getBlockEntity(this.getBlockPos());
            if (patt0$temp instanceof ExperienceConverterEntity) {
                ExperienceConverterEntity entity = (ExperienceConverterEntity)patt0$temp;
                entity.loadAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
                entity.setChanged();
                return;
            }
            this.setChanged();
        });
        this.fluidTank = new FluidTank(0, e -> e.is(AExpTags.Fluids.EXPERIENCE)){

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                long toInsert;
                long received;
                if (resource.is(AExpTags.Fluids.EXPERIENCE) && (received = ExperienceConverterEntity.this.experienceTank.receiveExperience(0, toInsert = (long)(resource.getAmount() / (Integer)AExpConfig.get().XP_CONVERSION_RATE.get()), true)) >= toInsert) {
                    ExperienceConverterEntity.this.experienceTank.receiveExperience(0, received, action.simulate());
                    return (int)received * (Integer)AExpConfig.get().XP_CONVERSION_RATE.get();
                }
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                long toExtract;
                long extracted;
                if (resource.is(AExpTags.Fluids.EXPERIENCE) && (extracted = ExperienceConverterEntity.this.experienceTank.extractExperience(0, toExtract = (long)(resource.getAmount() / (Integer)AExpConfig.get().XP_CONVERSION_RATE.get()), true)) >= toExtract) {
                    ExperienceConverterEntity.this.experienceTank.extractExperience(0, extracted, action.simulate());
                    return resource.copyWithAmount((int)extracted * (Integer)AExpConfig.get().XP_CONVERSION_RATE.get());
                }
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return this.drain(this.getFluid().copyWithAmount(maxDrain), action);
            }
        };
        this.setChangedQueued = false;
        this.inventoryIn = new AppEngInternalInventory((InternalInventoryHost)this, 1);
        this.inventoryIn.setFilter(ApexItemFilters.INSERT_ONLY);
        this.inventoryOut = new AppEngInternalInventory((InternalInventoryHost)this, 1);
        this.inventoryOut.setFilter(ApexItemFilters.EXTRACT_ONLY);
        this.internalInventory = new CombinedInternalInventory(new InternalInventory[]{this.inventoryIn, this.inventoryOut});
    }

    public void serverTick() {
        this.internalInventory.forEach(stack -> {
            if (!stack.is(Items.EXPERIENCE_BOTTLE)) {
                return;
            }
            int amount = stack.getCount();
            if (amount < 1) {
                return;
            }
            long received = this.experienceTank.receiveExperience(0, (long)((Integer)AExpConfig.get().XP_BOTTLE_XP_AMOUNT.get()).intValue(), true);
            ItemStack extracted = this.internalInventory.simulateSimilarRemove(1, Items.EXPERIENCE_BOTTLE.getDefaultInstance(), FuzzyMode.IGNORE_ALL, null);
            ItemStack remaining = this.internalInventory.addItems(Items.GLASS_BOTTLE.getDefaultInstance(), true);
            if (received < (long)((Integer)AExpConfig.get().XP_BOTTLE_XP_AMOUNT.get()).intValue()) {
                return;
            }
            if (extracted.isEmpty()) {
                return;
            }
            if (!remaining.isEmpty()) {
                return;
            }
            this.experienceTank.receiveExperience(0, (long)((Integer)AExpConfig.get().XP_BOTTLE_XP_AMOUNT.get()).intValue(), false);
            this.internalInventory.removeItems(1, extracted, null);
            this.internalInventory.addItems(Items.GLASS_BOTTLE.getDefaultInstance(), false);
        });
        this.setChanged();
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        super.saveToItem(stack, registries);
        stack.set(AExpComponents.EXPERIENCE_AMOUNT, (Object)this.getExperience());
        stack.set(AExpComponents.IN_INV, (Object)this.inventoryIn.toItemContainerContents());
        stack.set(AExpComponents.OUT_INV, (Object)this.inventoryOut.toItemContainerContents());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(AExpComponents.EXPERIENCE_AMOUNT, (Object)this.getExperience());
        components.set(AExpComponents.IN_INV, (Object)this.inventoryIn.toItemContainerContents());
        components.set(AExpComponents.OUT_INV, (Object)this.inventoryOut.toItemContainerContents());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        this.getExperienceTank().setExperience(0, ((Long)componentInput.getOrDefault(AExpComponents.EXPERIENCE_AMOUNT, (Object)0L)).longValue());
        this.inventoryIn.fromItemContainerContents((ItemContainerContents)componentInput.getOrDefault(AExpComponents.IN_INV, (Object)ItemContainerContents.fromItems(List.of(ItemStack.EMPTY))));
        this.inventoryOut.fromItemContainerContents((ItemContainerContents)componentInput.getOrDefault(AExpComponents.OUT_INV, (Object)ItemContainerContents.fromItems(List.of(ItemStack.EMPTY))));
    }

    public long getExperience() {
        return this.experienceTank.getExperience();
    }

    public long getExperienceCapacity() {
        return this.experienceTank.getExperienceCapacity();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("experienceTank", (Tag)this.experienceTank.serializeNBT(registries));
        CombinedInternalInventory inv = this.getInternalInventory();
        if (inv != InternalInventory.empty()) {
            CompoundTag opt = new CompoundTag();
            for (int x = 0; x < inv.size(); ++x) {
                ItemStack is = inv.getStackInSlot(x);
                opt.put("item" + x, is.saveOptional(registries));
            }
            tag.put("inv", (Tag)opt);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.experienceTank.deserializeNBT(registries, tag.getCompound("experienceTank"));
        CombinedInternalInventory inv = this.getInternalInventory();
        if (inv != InternalInventory.empty()) {
            CompoundTag opt = tag.getCompound("inv");
            for (int x = 0; x < inv.size(); ++x) {
                CompoundTag item = opt.getCompound("item" + x);
                inv.setItemDirect(x, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)item));
            }
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nullable
    public IGridNode getActionableNode() {
        return null;
    }

    public void openMenu(Player player, MenuHostLocator menuHostLocator) {
        if (!this.getLevel().isClientSide) {
            MenuOpener.open(AExpMenus.EXPERIENCE_CONVERTER, (Player)player, (MenuHostLocator)menuHostLocator);
        }
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        this.saveChanges();
    }

    public void saveChanges() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            this.setChanged();
        } else {
            this.level.blockEntityChanged(this.worldPosition);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.setChanged();
    }

    private void setChangedAtEndOfTick(@NotNull Level level) {
        this.setChanged();
        this.setChangedQueued = false;
    }

    public boolean isClientSide() {
        Level level = this.getLevel();
        return level == null || level.isClientSide();
    }

    @Generated
    public BasicExperienceHandler getExperienceTank() {
        return this.experienceTank;
    }

    @Generated
    public CombinedInternalInventory getInternalInventory() {
        return this.internalInventory;
    }
}

