/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.client.StorageCellModels;
import appeng.api.stacks.AEKeyType;
import appeng.core.definitions.ItemDefinition;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.PortableCellItem;
import es.degrassi.appexp.AppliedExperienced;
import es.degrassi.appexp.client.AExpStackRenderer;
import es.degrassi.appexp.client.renderer.entity.ExperienceConverterEntityRenderer;
import es.degrassi.appexp.client.renderer.item.ExperienceConverterItemRenderer;
import es.degrassi.appexp.definition.AExpBlockEntities;
import es.degrassi.appexp.definition.AExpBlocks;
import es.degrassi.appexp.definition.AExpItems;
import es.degrassi.appexp.item.ExperienceStorageCell;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.appexp.me.key.ExperienceKeyType;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="appex", dist={Dist.CLIENT})
public class AppliedExperiencedClient {
    public AppliedExperiencedClient(IEventBus bus) {
        AEKeyRendering.register((AEKeyType)ExperienceKeyType.TYPE, ExperienceKey.class, (AEKeyRenderHandler)new AExpStackRenderer());
        bus.addListener(this::registerItemColors);
        bus.addListener(this::initializeModels);
        bus.addListener(this::initBlockEntityRenderer);
        bus.addListener(this::registerClientExtensions);
    }

    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        for (ItemDefinition<ExperienceStorageCell> itemDefinition : AExpItems.getCells()) {
            event.register((stack, tintIndex) -> FastColor.ARGB32.opaque((int)BasicStorageCell.getColor((ItemStack)stack, (int)tintIndex)), new ItemLike[]{itemDefinition});
        }
        for (ItemDefinition itemDefinition : AExpItems.getPortables()) {
            event.register((stack, tintIndex) -> FastColor.ARGB32.opaque((int)PortableCellItem.getColor((ItemStack)stack, (int)tintIndex)), new ItemLike[]{itemDefinition});
        }
    }

    private void initializeModels(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            String prefix = "block/drive/cells/";
            for (int i = 0; i < AExpItems.getCells().size(); ++i) {
                ItemDefinition<ExperienceStorageCell> cell = AExpItems.getCells().get(i);
                StorageCellModels.registerModel((ItemLike)cell.get(), (ResourceLocation)AppliedExperienced.id(prefix + cell.id().getPath()));
                StorageCellModels.registerModel((ItemLike)AExpItems.getPortables().get(i).get(), (ResourceLocation)AppliedExperienced.id(prefix + cell.id().getPath()));
            }
        });
    }

    private void initBlockEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(AExpBlockEntities.EXPERIENCE_CONVERTER.get(), ExperienceConverterEntityRenderer::new);
    }

    private void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(this){

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ExperienceConverterItemRenderer.RENDERER;
            }
        }, new Item[]{AExpBlocks.EXPERIENCE_CONVERTER.item().get()});
    }
}

