/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.client.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.google.common.collect.Lists;
import es.degrassi.appexp.client.container.ExperienceConverterContainer;
import es.degrassi.experiencelib.util.ExperienceUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExperienceWidget
extends AbstractWidget
implements ITooltip {
    private final int screenWidth;
    private final ExperienceConverterContainer menu;

    public ExperienceWidget(int screenWidth, ExperienceConverterContainer menu) {
        super(8, 0, 16, 16, (Component)Component.empty());
        this.screenWidth = screenWidth;
        this.menu = menu;
    }

    public void playDownSound(SoundManager handler) {
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            this.width = this.screenWidth - 16;
            long level = ExperienceUtils.getLevelFromXp((long)this.menu.xp);
            String levels = "" + level;
            int xPos = this.getX() + this.width / 2 - Minecraft.getInstance().font.width(levels) / 2;
            graphics.drawString(Minecraft.getInstance().font, levels, xPos, this.getY(), 8453920, true);
            graphics.fill(this.getX(), this.getY() + 9, this.getX() + this.width, this.getY() + 12, -16777216);
            long xpDiff = this.menu.xp - ExperienceUtils.getXpFromLevel((long)level);
            if (xpDiff > 0L) {
                double percent = (double)xpDiff / (double)ExperienceUtils.getXpNeededForNextLevel((long)level);
                graphics.fill(this.getX() + 1, this.getY() + 10, this.getX() + 1 + Math.max((int)Math.ceil((double)this.width * percent) - 2, 0), this.getY() + 11, -8323296);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.screenWidth - 16, this.getHeight());
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    public List<Component> getTooltipMessage() {
        String literal = ExperienceUtils.format((long)this.menu.xp);
        String capacityLiteral = ExperienceUtils.format((long)this.menu.capacity) + "XP";
        String level = "" + ExperienceUtils.getLevelFromXp((long)this.menu.xp);
        String capacityLevel = ExperienceUtils.getLevelFromXp((long)this.menu.capacity) + " levels";
        return Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"appex.gui.element.experience.tooltip", (Object[])new Object[]{literal, capacityLiteral}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"appex.gui.element.experience.tooltip", (Object[])new Object[]{level, capacityLevel}).withStyle(ChatFormatting.GRAY)});
    }
}

