/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.definition;

import appeng.api.parts.PartModels;
import appeng.api.upgrades.Upgrades;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.materials.MaterialItem;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import appeng.items.storage.StorageTier;
import es.degrassi.appexp.definition.AExpBlocks;
import es.degrassi.appexp.definition.AExpText;
import es.degrassi.appexp.item.ExperiencePortableCellItem;
import es.degrassi.appexp.item.ExperienceStorageCell;
import es.degrassi.appexp.part.ExperienceAcceptorPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class AExpItems {
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"appex");
    private static final List<ItemDefinition<?>> ITEMS = new ArrayList();
    public static final DeferredRegister.Items DR = DeferredRegister.createItems((String)"appex");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = TABS.register("main", () -> CreativeModeTab.builder().title(AExpText.CREATIVE_TAB.formatted(new Object[0])).icon(() -> new ItemStack((ItemLike)EXPERIENCE_CELL_256K.get())).displayItems(AExpItems::display).build());
    public static final ItemDefinition<Item> EXPERIENCE_CELL_HOUSING = AExpItems.item("ME Experience Cell Housing", "experience_cell_housing", AExpItems::basic);
    public static final ItemDefinition<ExperienceStorageCell> EXPERIENCE_CELL_1K = AExpItems.cell(StorageTier.SIZE_1K);
    public static final ItemDefinition<ExperienceStorageCell> EXPERIENCE_CELL_4K = AExpItems.cell(StorageTier.SIZE_4K);
    public static final ItemDefinition<ExperienceStorageCell> EXPERIENCE_CELL_16K = AExpItems.cell(StorageTier.SIZE_16K);
    public static final ItemDefinition<ExperienceStorageCell> EXPERIENCE_CELL_64K = AExpItems.cell(StorageTier.SIZE_64K);
    public static final ItemDefinition<ExperienceStorageCell> EXPERIENCE_CELL_256K = AExpItems.cell(StorageTier.SIZE_256K);
    public static final ItemDefinition<ExperiencePortableCellItem> PORTABLE_EXPERIENCE_CELL_1K = AExpItems.portable(StorageTier.SIZE_1K, 8440575);
    public static final ItemDefinition<ExperiencePortableCellItem> PORTABLE_EXPERIENCE_CELL_4K = AExpItems.portable(StorageTier.SIZE_4K, 8440575);
    public static final ItemDefinition<ExperiencePortableCellItem> PORTABLE_EXPERIENCE_CELL_16K = AExpItems.portable(StorageTier.SIZE_16K, 8440575);
    public static final ItemDefinition<ExperiencePortableCellItem> PORTABLE_EXPERIENCE_CELL_64K = AExpItems.portable(StorageTier.SIZE_64K, 8440575);
    public static final ItemDefinition<ExperiencePortableCellItem> PORTABLE_EXPERIENCE_CELL_256K = AExpItems.portable(StorageTier.SIZE_256K, 8440575);
    public static final ItemDefinition<PartItem<ExperienceAcceptorPart>> EXPERIENCE_ACCEPTOR_PART = (ItemDefinition)Util.make(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(ExperienceAcceptorPart.class));
        return AExpItems.item("ME Experience Converter", "cable_experience_acceptor", p -> new PartItem(p, ExperienceAcceptorPart.class, ExperienceAcceptorPart::new));
    });

    private AExpItems() {
    }

    public static List<ItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    public static void initialize(IEventBus bus) {
        TABS.register(bus);
        DR.register(bus);
    }

    private static Item basic(Item.Properties p) {
        return new MaterialItem(p);
    }

    private static void display(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        ArrayList<Object> defs = new ArrayList<Object>();
        defs.addAll(AExpItems.getItems());
        defs.addAll(AExpBlocks.getBlocks().stream().map(BlockDefinition::item).toList());
        for (ItemDefinition itemDefinition : defs) {
            AEBaseBlockItem baseItem;
            Block block;
            Item item = itemDefinition.asItem();
            if (item instanceof AEBaseBlockItem && (block = (baseItem = (AEBaseBlockItem)item).getBlock()) instanceof AEBaseBlock) {
                AEBaseBlock baseBlock = (AEBaseBlock)block;
                baseBlock.addToMainCreativeTab(params, output);
                continue;
            }
            if (item instanceof AEBaseItem) {
                AEBaseItem baseItem2 = (AEBaseItem)item;
                baseItem2.addToMainCreativeTab(params, output);
                continue;
            }
            output.accept((ItemLike)itemDefinition);
        }
    }

    private static ItemDefinition<ExperienceStorageCell> cell(StorageTier tier) {
        return AExpItems.item(tier.namePrefix() + " ME Experience Storage Cell", "experience_storage_cell_" + tier.namePrefix(), p -> new ExperienceStorageCell(p.stacksTo(1), tier));
    }

    private static ItemDefinition<ExperiencePortableCellItem> portable(StorageTier tier, int defaultColor) {
        return AExpItems.item(tier.namePrefix() + " Portable Experience Cell", "portable_experience_cell_" + tier.namePrefix(), p -> new ExperiencePortableCellItem(tier, p.stacksTo(1), defaultColor));
    }

    private static <T extends Item> ItemDefinition<T> item(String englishName, String id, Function<Item.Properties, T> factory) {
        ItemDefinition definition = new ItemDefinition(englishName, DR.registerItem(id, factory));
        ITEMS.add(definition);
        return definition;
    }

    public static List<ItemDefinition<ExperienceStorageCell>> getCells() {
        return List.of(EXPERIENCE_CELL_1K, EXPERIENCE_CELL_4K, EXPERIENCE_CELL_16K, EXPERIENCE_CELL_64K, EXPERIENCE_CELL_256K);
    }

    public static List<ItemDefinition<ExperiencePortableCellItem>> getPortables() {
        return List.of(PORTABLE_EXPERIENCE_CELL_1K, PORTABLE_EXPERIENCE_CELL_4K, PORTABLE_EXPERIENCE_CELL_16K, PORTABLE_EXPERIENCE_CELL_64K, PORTABLE_EXPERIENCE_CELL_256K);
    }

    public static void initCellUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AExpItems.getCells().forEach(cell -> Upgrades.add((ItemLike)AEItems.VOID_CARD, () -> ((ItemDefinition)cell).get(), (int)1, (String)GuiText.StorageCells.getTranslationKey()));
            AExpItems.getPortables().forEach(cell -> {
                Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)cell, (int)2, (String)GuiText.PortableCells.getTranslationKey());
                Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)cell, (int)1, (String)GuiText.PortableCells.getTranslationKey());
            });
        });
    }
}

