/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnit;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.powersink.IExternalPowerSink;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public record ExperienceEnergyAdaptor(IExternalPowerSink sink, IActionHost host) implements IExperienceHandler
{
    private static final double AE_PER_EXPERIENCE = 32.0;

    public int getTanks() {
        return 1;
    }

    public boolean canAcceptExperience(int tank, long experience) {
        return this.receiveExperience(tank, experience, true) > 0L;
    }

    public boolean canProvideExperience(int tank, long experience) {
        return false;
    }

    public long getMaxExtract(int tank) {
        return 0L;
    }

    public long getMaxReceive(int tank) {
        return this.getExperienceCapacity();
    }

    public long getExperience() {
        return this.getExperienceCapacity() - Math.round(this.sink.getExternalPowerDemand(PowerUnit.AE, (double)this.getExperienceCapacity()) / 32.0);
    }

    public long getExperienceCapacity() {
        IGridNode grid = this.host.getActionableNode();
        return grid != null ? (long)((int)(grid.getGrid().getEnergyService().getMaxStoredPower() / 32.0)) : 0L;
    }

    public void setExperience(int tank, long experience) {
        throw new UnsupportedOperationException();
    }

    public void setCapacity(int tank, long l) {
        throw new UnsupportedOperationException();
    }

    public long receiveExperience(int tank, long experience, boolean simulate) {
        this.sink.injectExternalPower(PowerUnit.AE, (double)experience * 32.0, Actionable.ofSimulate((boolean)simulate));
        return Math.min(experience, this.getExperienceCapacity() - this.getExperience());
    }

    public long extractExperience(int tank, long experience, boolean simulate) {
        return 0L;
    }

    public long extractExperienceRecipe(int tank, long experience, boolean simulate) {
        return 0L;
    }

    public long receiveExperienceRecipe(int tank, long experience, boolean simulate) {
        this.sink.injectExternalPower(PowerUnit.AE, (double)experience * 32.0, Actionable.ofSimulate((boolean)simulate));
        return Math.min(experience, this.getExperienceCapacity() - this.getExperience());
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
    }
}

