/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.util.AECableType;
import appeng.blockentity.powersink.IExternalPowerSink;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import es.degrassi.appexp.AppliedExperienced;
import es.degrassi.appexp.me.misc.ExperienceEnergyAdaptor;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;

public class ExperienceAcceptorPart
extends AEBasePart
implements IExternalPowerSink {
    @PartModels
    private static final IPartModel MODEL = new PartModel(AppliedExperienced.id("part/experience_acceptor"));
    private final ExperienceEnergyAdaptor adaptor;

    public ExperienceAcceptorPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(0.0);
        this.adaptor = new ExperienceEnergyAdaptor(this, (IActionHost)this);
    }

    public static void registerCapability(RegisterPartCapabilitiesEvent event) {
        event.register(ExperienceLibCapabilities.EXPERIENCE.block(), (part, ctx) -> part.adaptor, ExperienceAcceptorPart.class);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
    }

    public final double getExternalPowerDemand(PowerUnit externalUnit, double maxPowerRequired) {
        double demand = this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnit.AE, maxPowerRequired));
        return PowerUnit.AE.convertTo(externalUnit, Math.max(0.0, demand));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().getEnergyDemand(maxRequired) : 0.0;
    }

    public final double injectExternalPower(PowerUnit input, double amt, Actionable mode) {
        return PowerUnit.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnit.AE, amt), mode));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().injectPower(power, mode) : power;
    }

    public final double injectAEPower(double amt, Actionable mode) {
        return amt;
    }

    public final double getAEMaxPower() {
        return 0.0;
    }

    public final double getAECurrentPower() {
        return 0.0;
    }

    public final boolean isAEPublicPowerStorage() {
        return false;
    }

    public final AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return 0.0;
    }
}

