/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.part;

import appeng.api.config.PowerUnit;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import es.degrassi.appexp.AppliedExperienced;
import es.degrassi.appexp.me.key.ExperienceKeyType;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.UnknownNullability;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExperienceP2PTunnelPart
extends CapabilityP2PTunnelPart<ExperienceP2PTunnelPart, IExperienceHandler> {
    private static final P2PModels MODELS = new P2PModels(AppliedExperienced.id("part/experience_p2p_tunnel"));
    private static final IExperienceHandler NULL_EXPERIENCE_HANDLER = new NullExperienceHandler();

    public ExperienceP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, ExperienceLibCapabilities.EXPERIENCE.block());
        this.inputHandler = new InputExperienceHandler();
        this.outputHandler = new OutputExperienceHandler();
        this.emptyHandler = NULL_EXPERIENCE_HANDLER;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private OutputExperienceHandler getOutputHandler() {
        return (OutputExperienceHandler)this.outputHandler;
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putLong("experience", this.getOutputHandler().bufferExperience);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.getOutputHandler().bufferExperience = data.getLong("experience");
    }

    private class InputExperienceHandler
    implements IExperienceHandler {
        private InputExperienceHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public boolean canAcceptExperience(int tank, long experience) {
            for (ExperienceP2PTunnelPart output : ExperienceP2PTunnelPart.this.getOutputs()) {
                if (!output.getOutputHandler().canAcceptLocalExperience(tank, experience)) continue;
                return true;
            }
            return false;
        }

        public boolean canProvideExperience(int tank, long experience) {
            return false;
        }

        public long getMaxExtract(int tank) {
            return 0L;
        }

        public long getMaxReceive(int tank) {
            return this.getExperienceCapacity();
        }

        public long getExperience() {
            return ExperienceP2PTunnelPart.this.getOutputStream().map(part -> part.getOutputHandler().getLocalExperience()).reduce(0L, Long::sum);
        }

        public void setExperience(int tank, long stack) {
            throw new UnsupportedOperationException();
        }

        public void setCapacity(int tank, long l) {
            throw new UnsupportedOperationException();
        }

        public long getExperienceCapacity() {
            return ExperienceP2PTunnelPart.this.getOutputStream().map(part -> part.getOutputHandler().getLocalMaxExperience()).reduce(0L, Long::sum);
        }

        public long receiveExperience(int tank, long stack, boolean simulate) {
            List<ExperienceP2PTunnelPart> outputs = ExperienceP2PTunnelPart.this.getOutputStream().filter(part -> part.getOutputHandler().canAcceptLocalExperience(tank, stack)).toList();
            if (outputs.isEmpty()) {
                return 0L;
            }
            if (!simulate) {
                ExperienceP2PTunnelPart.this.deductEnergyCost((double)stack / (double)ExperienceKeyType.TYPE.getAmountPerOperation(), PowerUnit.AE);
            }
            long forEach = stack / (long)outputs.size();
            AtomicLong spill = new AtomicLong(stack % (long)outputs.size());
            AtomicLong total = new AtomicLong(0L);
            outputs.forEach(output -> total.addAndGet(output.getOutputHandler().addExperienceRespectingBuffer(tank, forEach + (long)(spill.getAndDecrement() > 0L ? 1 : 0), simulate)));
            return total.get();
        }

        public long extractExperience(int tank, long amount, boolean simulate) {
            return 0L;
        }

        public long extractExperienceRecipe(int tank, long amount, boolean simulate) {
            return 0L;
        }

        public long receiveExperienceRecipe(int tank, long amount, boolean simulate) {
            List<ExperienceP2PTunnelPart> outputs = ExperienceP2PTunnelPart.this.getOutputStream().filter(part -> part.getOutputHandler().canAcceptLocalExperience(tank, amount)).toList();
            if (outputs.isEmpty()) {
                return 0L;
            }
            if (!simulate) {
                ExperienceP2PTunnelPart.this.deductEnergyCost((double)amount / (double)ExperienceKeyType.TYPE.getAmountPerOperation(), PowerUnit.AE);
            }
            long forEach = amount / (long)outputs.size();
            AtomicLong spill = new AtomicLong(amount % (long)outputs.size());
            AtomicLong total = new AtomicLong(0L);
            outputs.forEach(output -> total.addAndGet(output.getOutputHandler().addExperienceRespectingBuffer(tank, forEach + (long)(spill.getAndDecrement() > 0L ? 1 : 0), simulate)));
            return total.get();
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            return new CompoundTag();
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        }
    }

    private class OutputExperienceHandler
    implements IExperienceHandler {
        private static final long MAX_BUFFER = 1000L;
        private long bufferExperience = 0L;

        private OutputExperienceHandler() {
        }

        private boolean canAcceptLocalExperience(int tank, long source) {
            return this.getLocalExperience() + source < this.getLocalMaxExperience();
        }

        private long addExperienceRespectingBuffer(int tank, long amount, boolean simulate) {
            long experience = 0L;
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = ExperienceP2PTunnelPart.this.getAdjacentCapability();){
                IExperienceHandler tile = (IExperienceHandler)guard.get();
                if (tile != null && !(tile instanceof NullExperienceHandler)) {
                    experience += tile.receiveExperienceRecipe(tank, amount, simulate);
                    amount = 0L;
                }
            }
            this.bufferExperience += amount;
            if (this.bufferExperience > 1000L) {
                this.bufferExperience = 1000L;
            }
            return experience += this.bufferExperience;
        }

        private long getLocalExperience() {
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = ExperienceP2PTunnelPart.this.getAdjacentCapability();){
                long l = this.bufferExperience + ((IExperienceHandler)guard.get()).getExperience();
                return l;
            }
        }

        private long getLocalMaxExperience() {
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = ExperienceP2PTunnelPart.this.getAdjacentCapability();){
                long l = 1000L + ((IExperienceHandler)guard.get()).getExperience();
                return l;
            }
        }

        public int getTanks() {
            return 1;
        }

        public boolean canAcceptExperience(int tank, long experience) {
            return false;
        }

        public boolean canProvideExperience(int tank, long experience) {
            return this.extractExperience(tank, experience, true) > 0L;
        }

        public long getMaxExtract(int tank) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ExperienceP2PTunnelPart.this.getInputCapability();){
                IExperienceHandler tile = (IExperienceHandler)input.get();
                long l = tile != ExperienceP2PTunnelPart.this.emptyHandler ? tile.getMaxExtract(tank) : 1000L;
                return l;
            }
        }

        public long getMaxReceive(int tank) {
            return 0L;
        }

        public long getExperience() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ExperienceP2PTunnelPart.this.getInputCapability();){
                long l = ((IExperienceHandler)input.get()).getExperience() + this.bufferExperience;
                return l;
            }
        }

        public void setExperience(int tank, long stack) {
            throw new UnsupportedOperationException();
        }

        public void setCapacity(int tank, long l) {
            throw new UnsupportedOperationException();
        }

        public long getExperienceCapacity() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ExperienceP2PTunnelPart.this.getInputCapability();){
                long l = ((IExperienceHandler)input.get()).getExperienceCapacity() + 1000L;
                return l;
            }
        }

        public long receiveExperience(int tank, long stack, boolean actionable) {
            return 0L;
        }

        public long extractExperience(int tank, long amount, boolean simulate) {
            if (this.bufferExperience >= amount) {
                this.bufferExperience -= amount;
                return 0L;
            }
            this.bufferExperience = 0L;
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ExperienceP2PTunnelPart.this.getInputCapability();){
                long result = ((IExperienceHandler)input.get()).extractExperience(tank, amount, simulate);
                if (!simulate) {
                    ExperienceP2PTunnelPart.this.deductEnergyCost((double)result / (double)ExperienceKeyType.TYPE.getAmountPerOperation(), PowerUnit.AE);
                }
                long l = result;
                return l;
            }
        }

        public long extractExperienceRecipe(int tank, long amount, boolean simulate) {
            if (this.bufferExperience >= amount) {
                this.bufferExperience -= amount;
                return 0L;
            }
            this.bufferExperience = 0L;
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ExperienceP2PTunnelPart.this.getInputCapability();){
                long result = ((IExperienceHandler)input.get()).extractExperienceRecipe(tank, amount, simulate);
                if (!simulate) {
                    ExperienceP2PTunnelPart.this.deductEnergyCost((double)result / (double)ExperienceKeyType.TYPE.getAmountPerOperation(), PowerUnit.AE);
                }
                long l = result;
                return l;
            }
        }

        public long receiveExperienceRecipe(int tank, long amount, boolean simulate) {
            return 0L;
        }

        public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
            return null;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        }
    }

    private static class NullExperienceHandler
    implements IExperienceHandler {
        private NullExperienceHandler() {
        }

        public int getTanks() {
            return 0;
        }

        public boolean canAcceptExperience(int tank, long experience) {
            return false;
        }

        public boolean canProvideExperience(int tank, long experience) {
            return false;
        }

        public long getMaxExtract(int tank) {
            return 0L;
        }

        public long getMaxReceive(int tank) {
            return 0L;
        }

        public long getExperience() {
            return 0L;
        }

        public long getExperienceCapacity() {
            return 0L;
        }

        public void setExperience(int tank, long experience) {
        }

        public void setCapacity(int tank, long l) {
        }

        public long receiveExperience(int tank, long experience, boolean simulate) {
            return 0L;
        }

        public long extractExperience(int tank, long experience, boolean simulate) {
            return 0L;
        }

        public long extractExperienceRecipe(int tank, long amount, boolean simulate) {
            return 0L;
        }

        public long receiveExperienceRecipe(int tank, long amount, boolean simulate) {
            return 0L;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            return new CompoundTag();
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        }
    }
}

