/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.forge.NetworkManagerImpl;
import dev.architectury.networking.transformers.PacketCollector;
import dev.architectury.networking.transformers.PacketSink;
import dev.architectury.networking.transformers.PacketTransformer;
import dev.architectury.networking.transformers.SinglePacketCollector;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkManager {
    @Deprecated(forRemoval=true)
    public static void registerS2CPayloadType(ResourceLocation id) {
        NetworkAggregator.registerS2CType(id, List.of());
    }

    public static <T extends CustomPacketPayload> void registerS2CPayloadType(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        NetworkAggregator.registerS2CType(type, codec, List.of());
    }

    @Deprecated(forRemoval=true)
    public static void registerS2CPayloadType(ResourceLocation id, List<PacketTransformer> packetTransformers) {
        NetworkAggregator.registerS2CType(id, packetTransformers);
    }

    public static <T extends CustomPacketPayload> void registerS2CPayloadType(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, List<PacketTransformer> packetTransformers) {
        NetworkAggregator.registerS2CType(type, codec, packetTransformers);
    }

    @Deprecated(forRemoval=true)
    public static void registerReceiver(Side side, ResourceLocation id, NetworkReceiver<RegistryFriendlyByteBuf> receiver) {
        NetworkManager.registerReceiver(side, id, Collections.emptyList(), receiver);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    public static void registerReceiver(Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkReceiver<RegistryFriendlyByteBuf> receiver) {
        NetworkAggregator.registerReceiver(side, id, packetTransformers, receiver);
    }

    public static <T extends CustomPacketPayload> void registerReceiver(Side side, CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, NetworkReceiver<T> receiver) {
        NetworkManager.registerReceiver(side, id, codec, Collections.emptyList(), receiver);
    }

    @ApiStatus.Experimental
    public static <T extends CustomPacketPayload> void registerReceiver(Side side, CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, List<PacketTransformer> packetTransformers, NetworkReceiver<T> receiver) {
        NetworkAggregator.registerReceiver(side, id, codec, packetTransformers, receiver);
    }

    @Deprecated(forRemoval=true)
    public static Packet<?> toPacket(Side side, ResourceLocation id, RegistryFriendlyByteBuf buf) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, id, buf);
        return sink.getPacket();
    }

    @Deprecated(forRemoval=true)
    public static List<Packet<?>> toPackets(Side side, ResourceLocation id, RegistryFriendlyByteBuf buf) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, id, buf);
        return sink.collect();
    }

    public static <T extends CustomPacketPayload> Packet<?> toPacket(Side side, T payload, RegistryAccess access) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, payload, access);
        return sink.getPacket();
    }

    public static <T extends CustomPacketPayload> List<Packet<?>> toPackets(Side side, T payload, RegistryAccess access) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, payload, access);
        return sink.collect();
    }

    @Deprecated(forRemoval=true)
    public static void collectPackets(PacketSink sink, Side side, ResourceLocation id, RegistryFriendlyByteBuf buf) {
        NetworkAggregator.collectPackets(sink, side, id, buf);
    }

    public static <T extends CustomPacketPayload> void collectPackets(PacketSink sink, Side side, T payload, RegistryAccess access) {
        NetworkAggregator.collectPackets(sink, side, payload, access);
    }

    @Deprecated(forRemoval=true)
    public static void sendToPlayer(ServerPlayer player, ResourceLocation id, RegistryFriendlyByteBuf buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), id, buf);
    }

    @Deprecated(forRemoval=true)
    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation id, RegistryFriendlyByteBuf buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), id, buf);
    }

    @Deprecated(forRemoval=true)
    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation id, RegistryFriendlyByteBuf buf) {
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), id, buf);
    }

    public static <T extends CustomPacketPayload> void sendToPlayer(ServerPlayer player, T payload) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), payload, player.registryAccess());
    }

    public static <T extends CustomPacketPayload> void sendToPlayers(Iterable<ServerPlayer> players, T payload) {
        Iterator<ServerPlayer> iterator = players.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), payload, iterator.next().registryAccess());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends CustomPacketPayload> void sendToServer(T payload) {
        ClientPacketListener connection = GameInstance.getClient().getConnection();
        if (connection == null) {
            return;
        }
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), payload, (RegistryAccess)connection.registryAccess());
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(ResourceLocation id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (ResourceLocation)var1_1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canServerReceive(CustomPacketPayload.Type<?> type) {
        return NetworkManager.canServerReceive(type.id());
    }

    public static boolean canPlayerReceive(ServerPlayer player, CustomPacketPayload.Type<?> type) {
        return NetworkManager.canPlayerReceive(player, type.id());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<ClientGamePacketListener> createAddEntityPacket(Entity entity, ServerEntity serverEntity) {
        void var1_1;
        return NetworkManagerImpl.createAddEntityPacket(entity, (ServerEntity)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static NetworkAggregator.Adaptor getAdaptor() {
        return NetworkManagerImpl.getAdaptor();
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface NetworkReceiver<T> {
        public void receive(T var1, PacketContext var2);
    }

    public static interface PacketContext {
        public Player getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        public RegistryAccess registryAccess();

        default public Dist getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }
}

