/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.transformers;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@FunctionalInterface
public interface PacketSink {
    public static PacketSink ofPlayer(ServerPlayer player) {
        return packet -> Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").connection.send(packet);
    }

    public static PacketSink ofPlayers(Iterable<? extends ServerPlayer> players) {
        return packet -> {
            for (ServerPlayer player : players) {
                Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").connection.send(packet);
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PacketSink client() {
        return packet -> {
            if (Minecraft.getInstance().getConnection() == null) {
                throw new IllegalStateException("Unable to send packet to the server while not in game!");
            }
            Minecraft.getInstance().getConnection().send(packet);
        };
    }

    public void accept(Packet<?> var1);
}

