/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.capability;

import com.github.ars_affinity.capability.WetTicks;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WetTicksProvider {
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"wet_ticks");
    private static final Map<UUID, WetTicks> playerWetTicksCache = new HashMap<UUID, WetTicks>();

    public static WetTicks getWetTicks(Player player) {
        UUID playerId = player.getUUID();
        return playerWetTicksCache.computeIfAbsent(playerId, id -> {
            WetTicks newWetTicks = new WetTicks();
            CompoundTag playerData = player.getPersistentData();
            if (playerData.contains(IDENTIFIER.toString())) {
                CompoundTag wetTicksData = playerData.getCompound(IDENTIFIER.toString());
                newWetTicks.deserializeNBT(wetTicksData);
            }
            return newWetTicks;
        });
    }

    public static void loadPlayerWetTicks(Player player) {
        WetTicksProvider.getWetTicks(player);
    }

    public static void savePlayerWetTicks(Player player) {
        UUID playerId = player.getUUID();
        WetTicks wetTicks = playerWetTicksCache.get(playerId);
        if (wetTicks != null) {
            CompoundTag playerData = player.getPersistentData();
            CompoundTag wetTicksData = wetTicks.serializeNBT();
            playerData.put(IDENTIFIER.toString(), (Tag)wetTicksData);
        }
    }

    public static void saveAllWetTicks() {
    }

    public static void clearCache() {
        playerWetTicksCache.clear();
    }

    public static int getCacheSize() {
        return playerWetTicksCache.size();
    }
}

