/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.particles;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.client.particles.SpiralParticleHelper;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SpiralParticle
extends TextureSheetParticle {
    private final float radius;
    private final float speed;
    private final int playerId;
    private final String schoolId;
    private final float initialAngle;
    private final float initialQuadSize;
    private final float chaosAmount;

    protected SpiralParticle(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float scale, int lifetime, SpriteSet sprite, int playerId, String schoolId) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.radius = 5.0f * scale;
        this.speed = 0.05f;
        this.playerId = playerId;
        this.schoolId = schoolId;
        this.initialAngle = (float)(Math.random() * 2.0 * Math.PI);
        this.chaosAmount = (float)(Math.random() * 0.5 + 0.25);
        this.initialQuadSize = this.quadSize = scale * 0.25f + (float)(Math.random() * (double)0.05f);
        this.hasPhysics = false;
        this.xd = ParticleUtil.inRange((double)-0.01, (double)0.01);
        this.yd = 0.001;
        this.zd = ParticleUtil.inRange((double)-0.01, (double)0.01);
        this.setPos(x, y, z);
        this.friction = 0.99f;
        this.speedUpWhenYMotionIsBlocked = false;
        this.setColor(r, g, b);
        this.lifetime = 60;
        this.pickSprite(sprite);
        ArsAffinity.LOGGER.debug("SpiralParticle created at ({}, {}, {}) with color ({}, {}, {}), size={}, lifetime={}, radius={}, speed={}", (Object)x, (Object)y, (Object)z, (Object)Float.valueOf(r), (Object)Float.valueOf(g), (Object)Float.valueOf(b), (Object)Float.valueOf(this.quadSize), (Object)this.lifetime, (Object)Float.valueOf(this.radius), (Object)Float.valueOf(this.speed));
    }

    public void tick() {
        super.tick();
        float progress = Math.min((float)this.age / (float)this.lifetime, 1.0f);
        float rotationalAcceleration = 1.0f + SpiralParticle.easeOutExpo(progress) * 3.0f;
        float currentAngle = this.initialAngle + (float)this.age * this.speed * rotationalAcceleration;
        float currentRadius = this.radius * (0.1f + progress * 0.01f);
        SpiralParticleHelper.SpiralParticleCenter center = SpiralParticleHelper.getParticleCenter(this.playerId, this.schoolId);
        if (center == null) {
            this.remove();
            return;
        }
        double centerX = center.getCurrentX();
        double centerY = center.getCurrentY();
        double centerZ = center.getCurrentZ();
        double x = centerX + (double)currentRadius * Math.sin(currentAngle);
        double z = centerZ + (double)currentRadius * Math.cos(currentAngle);
        double easedY = centerY + (double)(SpiralParticle.easeOutExpo(progress) * 2.0f);
        if (SpiralParticle.shouldApplyChaos(this.schoolId)) {
            float chaosProgress = SpiralParticle.easeInQuad(progress);
            double chaosX = (Math.random() - 0.5) * 2.0 * (double)this.chaosAmount * (double)chaosProgress;
            double chaosY = (Math.random() - 0.5) * 2.0 * (double)this.chaosAmount * (double)chaosProgress;
            double chaosZ = (Math.random() - 0.5) * 2.0 * (double)this.chaosAmount * (double)chaosProgress;
            x += chaosX;
            easedY += chaosY;
            z += chaosZ;
        }
        float sizeProgress = Math.min((float)this.age / (float)this.lifetime, 1.0f);
        float sizeFade = 1.0f - SpiralParticle.easeOutExpo(sizeProgress * 0.75f);
        this.quadSize = this.initialQuadSize * sizeFade;
        this.setPos(x, easedY, z);
    }

    private static float easeOutExpo(float t) {
        return t == 1.0f ? 1.0f : (float)(1.0 - Math.pow(2.0, -10.0f * t));
    }

    private static float easeInExpo(float t) {
        return t == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * (t - 1.0f));
    }

    private static float easeInQuad(float t) {
        return t * t;
    }

    private static boolean shouldApplyChaos(String schoolId) {
        return "elemental_fire".equals(schoolId) || "elemental_air".equals(schoolId);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

