/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.particles;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.client.particles.SpiralParticleTypeData;
import com.github.ars_affinity.registry.ParticleRegistry;
import com.github.ars_affinity.util.SchoolColors;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SpiralParticleHelper {
    private static final Map<SpellSchool, Float> SCHOOL_SCALES = new HashMap<SpellSchool, Float>();
    private static final Map<SpellSchool, ResourceLocation> SCHOOL_PARTICLE_TYPES = new HashMap<SpellSchool, ResourceLocation>();
    private static final Map<String, SpiralParticleCenter> activeEffects = new ConcurrentHashMap<String, SpiralParticleCenter>();

    public static void spawnSpiralParticles(ClientLevel level, Player player, SpellSchool school, int particleCount) {
        SpiralParticleHelper.spawnSpiralParticles(level, player, school, particleCount, 0);
    }

    public static void spawnSpiralParticlesAtPosition(ClientLevel level, Vec3 position, SpellSchool school, int particleCount) {
        ArsAffinity.LOGGER.debug("SpiralParticleHelper.spawnSpiralParticlesAtPosition called at position ({}, {}, {})", (Object)position.x, (Object)position.y, (Object)position.z);
        if (level == null || position == null || school == null) {
            ArsAffinity.LOGGER.warn("SpiralParticleHelper: Null parameters detected for position spawn");
            return;
        }
        ParticleColor color = SchoolColors.getParticleColor(school);
        Float scale = SCHOOL_SCALES.get(school);
        if (scale == null) {
            scale = Float.valueOf(1.0f);
        }
        double x = position.x;
        double y = position.y;
        double z = position.z;
        int successfulSpawns = 0;
        for (int i = 0; i < particleCount; ++i) {
            String spriteType = SpiralParticleHelper.getSpriteTypeForSchool(school);
            SpiralParticleTypeData particleData = new SpiralParticleTypeData((ParticleType<? extends SpiralParticleTypeData>)((ParticleType)ParticleRegistry.SPIRAL_FIRE.get()), color, false, 1.0f, 1.0f, 40, spriteType, 0, "default");
            try {
                level.addParticle((ParticleOptions)particleData, x, y, z, 0.0, 0.0, 0.0);
                ++successfulSpawns;
                continue;
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("SpiralParticleHelper: Error spawning particle {}: {}", (Object)i, (Object)e.getMessage(), (Object)e);
            }
        }
        ArsAffinity.LOGGER.debug("SpiralParticleHelper: Successfully spawned {}/{} particles at position", (Object)successfulSpawns, (Object)particleCount);
    }

    public static void spawnSpiralParticles(ClientLevel level, Player player, SpellSchool school, int particleCount, int delayTicks) {
        ArsAffinity.LOGGER.debug("=== SPIRAL PARTICLE HELPER START ===");
        ArsAffinity.LOGGER.debug("SpiralParticleHelper.spawnSpiralParticles called with level={}, player={}, school={}, count={}", (Object)(level != null ? "ClientLevel" : "null"), (Object)(player != null ? player.getName().getString() : "null"), (Object)(school != null ? school.getId() : "null"), (Object)particleCount);
        if (level == null || player == null || school == null) {
            ArsAffinity.LOGGER.warn("SpiralParticleHelper: Null parameters detected, aborting particle spawn");
            ArsAffinity.LOGGER.warn("SpiralParticleHelper: level={}, player={}, school={}", (Object)(level != null ? 1 : 0), (Object)(player != null ? 1 : 0), (Object)(school != null ? 1 : 0));
            ArsAffinity.LOGGER.debug("=== SPIRAL PARTICLE HELPER END (NULL PARAMS) ===");
            return;
        }
        ParticleColor color = SchoolColors.getParticleColor(school);
        Float scale = SCHOOL_SCALES.get(school);
        if (scale == null) {
            ArsAffinity.LOGGER.warn("SpiralParticleHelper: School not found in scale map, using default");
            scale = Float.valueOf(1.0f);
        }
        ArsAffinity.LOGGER.debug("SpiralParticleHelper: Using color={}, scale={}", (Object)color, (Object)scale);
        Vec3 playerPos = player.position();
        double x = playerPos.x;
        double y = playerPos.y;
        double z = playerPos.z;
        ArsAffinity.LOGGER.debug("SpiralParticleHelper: Player position: ({}, {}, {}), eye height: {}", (Object)playerPos.x, (Object)playerPos.y, (Object)playerPos.z, (Object)Float.valueOf(player.getEyeHeight()));
        ArsAffinity.LOGGER.debug("SpiralParticleHelper: Spawning particles at position ({}, {}, {})", (Object)x, (Object)y, (Object)z);
        ArsAffinity.LOGGER.debug("SpiralParticleHelper: Particle type: {}", ParticleRegistry.SPIRAL_FIRE.get());
        SpiralParticleHelper.registerParticleEffect(player.getId(), school.getId().toString(), x, y, z);
        int successfulSpawns = 0;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = 0.0;
            double offsetY = 0.0;
            double offsetZ = 0.0;
            String spriteType = SpiralParticleHelper.getSpriteTypeForSchool(school);
            SpiralParticleTypeData particleData = new SpiralParticleTypeData(SpiralParticleHelper.getParticleTypeForSchool(school), color, false, 1.0f, 1.0f, 40, spriteType, player.getId(), school.getId().toString());
            try {
                level.addParticle((ParticleOptions)particleData, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
                ++successfulSpawns;
                if (i >= 5) continue;
                ArsAffinity.LOGGER.debug("SpiralParticleHelper: Spawned particle {} at ({}, {}, {})", (Object)i, (Object)(x + offsetX), (Object)(y + offsetY), (Object)(z + offsetZ));
                continue;
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("SpiralParticleHelper: Error spawning particle {}: {}", (Object)i, (Object)e.getMessage(), (Object)e);
            }
        }
        ArsAffinity.LOGGER.debug("SpiralParticleHelper: Successfully spawned {}/{} particles", (Object)successfulSpawns, (Object)particleCount);
        ArsAffinity.LOGGER.debug("=== SPIRAL PARTICLE HELPER END ===");
    }

    public static ParticleColor getSchoolColor(SpellSchool school) {
        return SchoolColors.getParticleColor(school);
    }

    public static float getSchoolScale(SpellSchool school) {
        return SCHOOL_SCALES.getOrDefault(school, Float.valueOf(1.0f)).floatValue();
    }

    public static String getSpriteTypeForSchool(SpellSchool school) {
        return switch (school.getId().toString()) {
            case "fire" -> "flame";
            case "elemental_water" -> "bubble";
            default -> "flame";
        };
    }

    public static void updateParticleCenter(int playerId, String schoolId, double x, double y, double z) {
        String key = playerId + "_" + schoolId;
        SpiralParticleCenter center = activeEffects.get(key);
        if (center != null) {
            center.updateTargetPosition(x, y, z);
        }
    }

    public static void registerParticleEffect(int playerId, String schoolId, double x, double y, double z) {
        String key = playerId + "_" + schoolId;
        activeEffects.put(key, new SpiralParticleCenter(x, y, z));
    }

    public static void unregisterParticleEffect(int playerId, String schoolId) {
        String key = playerId + "_" + schoolId;
        activeEffects.remove(key);
    }

    public static SpiralParticleCenter getParticleCenter(int playerId, String schoolId) {
        String key = playerId + "_" + schoolId;
        return activeEffects.get(key);
    }

    public static ParticleType<SpiralParticleTypeData> getParticleTypeForSchool(SpellSchool school) {
        return switch (school.getId().toString()) {
            case "fire" -> (ParticleType)ParticleRegistry.SPIRAL_FIRE.get();
            case "water" -> (ParticleType)ParticleRegistry.SPIRAL_WATER.get();
            case "earth" -> (ParticleType)ParticleRegistry.SPIRAL_EARTH.get();
            case "air" -> (ParticleType)ParticleRegistry.SPIRAL_AIR.get();
            case "manipulation" -> (ParticleType)ParticleRegistry.SPIRAL_MANIPULATION.get();
            case "abjuration" -> (ParticleType)ParticleRegistry.SPIRAL_ABJURATION.get();
            case "necromancy" -> (ParticleType)ParticleRegistry.SPIRAL_NECROMANCY.get();
            case "conjuration" -> (ParticleType)ParticleRegistry.SPIRAL_CONJURATION.get();
            default -> (ParticleType)ParticleRegistry.SPIRAL_FIRE.get();
        };
    }

    static {
        SCHOOL_SCALES.put(SpellSchools.ELEMENTAL_FIRE, Float.valueOf(1.2f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.ELEMENTAL_FIRE, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.FLAME));
        SCHOOL_SCALES.put(SpellSchools.ELEMENTAL_WATER, Float.valueOf(1.0f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.ELEMENTAL_WATER, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.BUBBLE));
        SCHOOL_SCALES.put(SpellSchools.ELEMENTAL_EARTH, Float.valueOf(1.1f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.ELEMENTAL_EARTH, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.DUST_PLUME));
        SCHOOL_SCALES.put(SpellSchools.ELEMENTAL_AIR, Float.valueOf(0.9f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.ELEMENTAL_AIR, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.ELECTRIC_SPARK));
        SCHOOL_SCALES.put(SpellSchools.MANIPULATION, Float.valueOf(1.0f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.MANIPULATION, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.FIREWORK));
        SCHOOL_SCALES.put(SpellSchools.ABJURATION, Float.valueOf(1.1f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.ABJURATION, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.HEART));
        SCHOOL_SCALES.put(SpellSchools.NECROMANCY, Float.valueOf(1.0f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.NECROMANCY, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.SOUL));
        SCHOOL_SCALES.put(SpellSchools.CONJURATION, Float.valueOf(1.0f));
        SCHOOL_PARTICLE_TYPES.put(SpellSchools.CONJURATION, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.ENCHANT));
    }

    public static class SpiralParticleCenter {
        private double currentX;
        private double currentY;
        private double currentZ;
        private double targetX;
        private double targetY;
        private double targetZ;
        private double prevX;
        private double prevY;
        private double prevZ;
        private long lastUpdateTime;
        private long creationTime;

        public SpiralParticleCenter(double x, double y, double z) {
            this.targetX = this.prevX = x;
            this.currentX = this.prevX;
            this.targetY = this.prevY = y;
            this.currentY = this.prevY;
            this.targetZ = this.prevZ = z;
            this.currentZ = this.prevZ;
            this.lastUpdateTime = System.currentTimeMillis();
            this.creationTime = System.currentTimeMillis();
        }

        public void updateTargetPosition(double x, double y, double z) {
            this.currentX = x;
            this.currentY = y;
            this.currentZ = z;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public double getCurrentX() {
            return this.currentX;
        }

        public double getCurrentY() {
            return this.currentY;
        }

        public double getCurrentZ() {
            return this.currentZ;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.creationTime > 5000L;
        }
    }
}

