/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class SchoolGlyphScreen
extends BaseDocScreen {
    List<DocEntry> entries;
    List<DocEntryButton> buttons = new ArrayList<DocEntryButton>();
    SpellSchool selectedSchool;
    private final Screen previousScreen;
    private final List<SpellSchool> schools;

    public SchoolGlyphScreen(Screen previousScreen, SpellSchool selectedSchool) {
        this.previousScreen = previousScreen;
        this.schools = List.of(SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR, SpellSchools.ABJURATION, SpellSchools.NECROMANCY, SpellSchools.CONJURATION, SpellSchools.MANIPULATION);
        this.selectedSchool = selectedSchool;
        this.updateGlyphsForSchool();
    }

    private void updateGlyphsForSchool() {
        ArrayList entries = new ArrayList(GlyphRegistry.getSpellpartMap().values().stream().filter(part -> part.spellSchools.contains(this.selectedSchool)).map(part -> DocumentationRegistry.getEntry((ResourceLocation)part.getRegistryName())).filter(entry -> entry != null).sorted((a, b) -> {
            Item patt0$temp = a.renderStack().getItem();
            if (patt0$temp instanceof Glyph) {
                Glyph glyph1 = (Glyph)patt0$temp;
                Item patt1$temp = b.renderStack().getItem();
                if (patt1$temp instanceof Glyph) {
                    Glyph glyph2 = (Glyph)patt1$temp;
                    int tierCompare = Integer.compare(glyph1.spellPart.getConfigTier().value, glyph2.spellPart.getConfigTier().value);
                    if (tierCompare != 0) {
                        return tierCompare;
                    }
                    return a.entryTitle().getString().compareTo(b.entryTitle().getString());
                }
            }
            return a.entryTitle().getString().compareTo(b.entryTitle().getString());
        }).collect(Collectors.toList()));
        this.entries = new ArrayList<DocEntry>(entries);
        this.arrowIndex = 0;
        this.maxArrowIndex = this.entries.size() > 17 ? 1 + (this.entries.size() - 17) / 18 : 0;
        if (this.arrowIndex > this.maxArrowIndex) {
            this.arrowIndex = this.maxArrowIndex;
        }
    }

    public void init() {
        super.init();
        this.initButtons();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.renderSchoolTabs(graphics, centerX, centerY, mouseX, mouseY);
        if (this.arrowIndex == 0) {
            DocClientUtils.drawHeader((Component)this.selectedSchool.getTextComponent(), (GuiGraphics)graphics, (int)(this.screenLeft + 19), (int)(this.screenTop + 17), (int)118, (int)mouseX, (int)mouseY, (float)partialTicks);
        }
    }

    private void renderSchoolTabs(GuiGraphics guiGraphics, int centerX, int centerY, int mouseX, int mouseY) {
        int startX = centerX + 144;
        int startY = centerY - 86;
        for (int i = 0; i < this.schools.size(); ++i) {
            boolean isHovered;
            SpellSchool school = this.schools.get(i);
            int tabX = startX;
            int tabY = startY + i * 22;
            boolean isSelected = school.equals(this.selectedSchool);
            boolean bl = isHovered = mouseX >= tabX && mouseX < tabX + 18 && mouseY >= tabY && mouseY < tabY + 13;
            if (isSelected) {
                guiGraphics.blit(DocAssets.SPELL_TAB_ICON_SELECTED.location(), tabX, tabY, 0.0f, 0.0f, 18, 13, 18, 13);
            } else {
                guiGraphics.blit(DocAssets.SPELL_TAB_ICON.location(), tabX, tabY, 0.0f, 0.0f, 18, 13, 18, 13);
            }
            ResourceLocation iconTexture = school.getTexturePath();
            int iconSize = 16;
            int iconX = tabX;
            int iconY = tabY - 2;
            guiGraphics.blit(iconTexture, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            if (!isHovered || isSelected) continue;
            Component schoolName = school.getTextComponent();
            guiGraphics.renderTooltip(this.font, schoolName, mouseX, mouseY);
        }
    }

    public void onArrowIndexChange() {
        super.onArrowIndexChange();
        this.initButtons();
    }

    public void initButtons() {
        for (DocEntryButton button : this.buttons) {
            this.removeWidget((GuiEventListener)button);
        }
        this.buttons.clear();
        int offset = 17;
        if (this.arrowIndex == 0) {
            this.getLeftPageButtons(0, 8);
            this.getRightPageButtons(8, offset);
        } else {
            int offsetIndex = this.arrowIndex * 18 - 1;
            this.getLeftPageButtons(offsetIndex, offsetIndex + 9);
            this.getRightPageButtons(offsetIndex + 9, offsetIndex + 18);
        }
    }

    public void getLeftPageButtons(int from, int to) {
        List<DocEntry> sliced = this.entries.subList(from, Math.min(to, this.entries.size()));
        boolean offset = to - from == 8;
        for (int i = 0; i < sliced.size(); ++i) {
            DocEntry entry = sliced.get(i);
            DocEntryButton button = new DocEntryButton(this.screenLeft + 19, this.screenTop + 17 + 3 + 16 * i + (offset ? 16 : 0), entry, b -> this.transition((BaseDocScreen)new PageHolderScreen(entry)));
            this.addRenderableWidget((GuiEventListener)button);
            this.buttons.add(button);
        }
    }

    public void getRightPageButtons(int from, int to) {
        if (from > this.entries.size()) {
            return;
        }
        List<DocEntry> sliced = this.entries.subList(from, Math.min(to, this.entries.size()));
        for (int i = 0; i < sliced.size(); ++i) {
            DocEntry entry = sliced.get(i);
            DocEntryButton button = new DocEntryButton(this.screenLeft + 153, this.screenTop + 17 + 3 + 16 * i, entry, b -> this.transition((BaseDocScreen)new PageHolderScreen(entry)));
            this.addRenderableWidget((GuiEventListener)button);
            this.buttons.add(button);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int centerX = this.width / 2;
            int centerY = this.height / 2;
            int startX = centerX + 144;
            int startY = centerY - 86;
            for (int i = 0; i < this.schools.size(); ++i) {
                SpellSchool school = this.schools.get(i);
                int tabX = startX;
                int tabY = startY + i * 22;
                if (!(mouseX >= (double)tabX) || !(mouseX < (double)(tabX + 18)) || !(mouseY >= (double)tabY) || !(mouseY < (double)(tabY + 13))) continue;
                this.selectedSchool = school;
                this.updateGlyphsForSchool();
                this.initButtons();
                this.onArrowIndexChange();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void goBack() {
        if (this.previousScreen != null) {
            this.minecraft.setScreen(this.previousScreen);
        } else {
            super.goBack();
        }
    }
}

