/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.client.screen.perk.BezierCurve;
import com.github.ars_affinity.client.screen.perk.ConnectionStyle;
import com.github.ars_affinity.client.screen.perk.ConnectionType;
import com.github.ars_affinity.perk.PerkNode;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.List;

public class PerkConnectionPath {
    private final BezierCurve curve;
    private final ConnectionType type;
    private final ConnectionStyle style;

    public PerkConnectionPath(PerkNode from, PerkNode to, SpellSchool school, int fromX, int fromY, int toX, int toY) {
        this.type = this.determineConnectionType(from, to);
        this.style = ConnectionStyle.forType(this.type, school);
        this.curve = this.createCurve(fromX, fromY, toX, toY);
    }

    private ConnectionType determineConnectionType(PerkNode from, PerkNode to) {
        if (from.getTier() < to.getTier()) {
            return ConnectionType.PREREQUISITE;
        }
        if (from.getTier() == to.getTier()) {
            return ConnectionType.AVAILABLE;
        }
        return ConnectionType.LOCKED;
    }

    private BezierCurve createCurve(int fromX, int fromY, int toX, int toY) {
        return new BezierCurve(new BezierCurve.Point(fromX, fromY), new BezierCurve.Point(toX, toY));
    }

    public List<BezierCurve.Point> getPathPoints(int segments) {
        return this.curve.generatePoints(segments);
    }

    public ConnectionType getType() {
        return this.type;
    }

    public ConnectionStyle getStyle() {
        return this.style;
    }
}

