/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.perk.PerkNode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Mth;

public class PerkTreeAnimator {
    private final Map<String, NodeAnimation> nodeAnimations = new HashMap<String, NodeAnimation>();
    private final Map<String, Float> hoverAnimations = new HashMap<String, Float>();

    public void update(float partialTick) {
        this.nodeAnimations.values().forEach(anim -> anim.update(partialTick));
        this.hoverAnimations.replaceAll((key, value) -> {
            float target = value.floatValue() > 0.5f ? 1.0f : 0.0f;
            return Float.valueOf(Mth.lerp((float)0.1f, (float)value.floatValue(), (float)target));
        });
    }

    public void setNodeHovered(String nodeId, boolean hovered) {
        this.hoverAnimations.put(nodeId, Float.valueOf(hovered ? 1.0f : 0.0f));
    }

    public float getHoverAnimation(String nodeId) {
        return this.hoverAnimations.getOrDefault(nodeId, Float.valueOf(0.0f)).floatValue();
    }

    public void animateNodeAppearance(String nodeId, PerkNode node) {
        NodeAnimation anim = this.nodeAnimations.computeIfAbsent(nodeId, k -> new NodeAnimation());
        anim.startAppearanceAnimation();
    }

    public void animateNodeAllocation(String nodeId, boolean allocated) {
        NodeAnimation anim = this.nodeAnimations.computeIfAbsent(nodeId, k -> new NodeAnimation());
        anim.startAllocationAnimation(allocated);
    }

    public float getNodeScale(String nodeId) {
        NodeAnimation anim = this.nodeAnimations.get(nodeId);
        return anim != null ? anim.getScale() : 1.0f;
    }

    public float getNodeAlpha(String nodeId) {
        NodeAnimation anim = this.nodeAnimations.get(nodeId);
        return anim != null ? anim.getAlpha() : 1.0f;
    }

    public float getNodeGlow(String nodeId) {
        NodeAnimation anim = this.nodeAnimations.get(nodeId);
        return anim != null ? anim.getGlow() : 0.0f;
    }

    private static class NodeAnimation {
        private float scale = 1.0f;
        private float alpha = 1.0f;
        private float glow = 0.0f;
        private float targetScale = 1.0f;
        private float targetAlpha = 1.0f;
        private float targetGlow = 0.0f;
        private int animationTime = 0;
        private int maxAnimationTime = 0;

        private NodeAnimation() {
        }

        public void update(float partialTick) {
            if (this.animationTime < this.maxAnimationTime) {
                ++this.animationTime;
                float progress = (float)this.animationTime / (float)this.maxAnimationTime;
                float easedProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
                this.scale = Mth.lerp((float)easedProgress, (float)this.scale, (float)this.targetScale);
                this.alpha = Mth.lerp((float)easedProgress, (float)this.alpha, (float)this.targetAlpha);
                this.glow = Mth.lerp((float)easedProgress, (float)this.glow, (float)this.targetGlow);
            }
        }

        public void startAppearanceAnimation() {
            this.scale = 0.0f;
            this.alpha = 0.0f;
            this.targetScale = 1.0f;
            this.targetAlpha = 1.0f;
            this.animationTime = 0;
            this.maxAnimationTime = 20;
        }

        public void startAllocationAnimation(boolean allocated) {
            this.targetScale = allocated ? 1.2f : 1.0f;
            this.targetGlow = allocated ? 1.0f : 0.0f;
            this.animationTime = 0;
            this.maxAnimationTime = 10;
        }

        public float getScale() {
            return this.scale;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public float getGlow() {
            return this.glow;
        }
    }
}

