/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.HashMap;
import java.util.Map;

public class SchoolColorHelper {
    private static final Map<SpellSchool, SchoolColor> SCHOOL_COLORS = new HashMap<SpellSchool, SchoolColor>();

    public static int getSchoolColor(SpellSchool school) {
        SchoolColor color = SCHOOL_COLORS.get(school);
        return color != null ? color.primary : -10066330;
    }

    public static int getSchoolHoverColor(SpellSchool school) {
        SchoolColor color = SCHOOL_COLORS.get(school);
        return color != null ? color.hover : -7829368;
    }

    public static int getSchoolAllocatedColor(SpellSchool school) {
        SchoolColor color = SCHOOL_COLORS.get(school);
        return color != null ? color.allocated : -15681151;
    }

    static {
        SCHOOL_COLORS.put(SpellSchools.MANIPULATION, new SchoolColor(-1467816, -871578, -1467816));
        SCHOOL_COLORS.put(SpellSchools.ELEMENTAL_FIRE, new SchoolColor(-1022362, -685430, -1022362));
        SCHOOL_COLORS.put(SpellSchools.NECROMANCY, new SchoolColor(-1842205, -1842205, -1842205));
        SCHOOL_COLORS.put(SpellSchools.ELEMENTAL_AIR, new SchoolColor(-2830502, -2040710, -2830502));
        SCHOOL_COLORS.put(SpellSchools.CONJURATION, new SchoolColor(-9772082, -7673386, -9772082));
        SCHOOL_COLORS.put(SpellSchools.ELEMENTAL_WATER, new SchoolColor(-8215827, -6178064, -8215827));
        SCHOOL_COLORS.put(SpellSchools.ABJURATION, new SchoolColor(-1344306, -1009191, -1344306));
        SCHOOL_COLORS.put(SpellSchools.ELEMENTAL_EARTH, new SchoolColor(-10296682, -8460120, -10296682));
    }

    private static class SchoolColor {
        final int primary;
        final int hover;
        final int allocated;

        SchoolColor(int primary, int hover, int allocated) {
            this.primary = primary;
            this.hover = hover;
            this.allocated = allocated;
        }
    }
}

