/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.sound;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.registry.ModSounds;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class LoopingSoundManager {
    private static final Map<String, PlayerLoopingSound> activeSounds = new HashMap<String, PlayerLoopingSound>();

    public static void startLoopingSound(Player player, String soundId) {
        String key = player.getId() + "_" + soundId;
        if (activeSounds.containsKey(key)) {
            return;
        }
        SoundEvent soundEvent = LoopingSoundManager.getSoundEvent(soundId);
        if (soundEvent == null) {
            ArsAffinity.LOGGER.warn("Unknown sound ID: {}", (Object)soundId);
            return;
        }
        PlayerLoopingSound sound = new PlayerLoopingSound(player, soundEvent);
        activeSounds.put(key, sound);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
        ArsAffinity.LOGGER.debug("Started looping sound {} for player {}", (Object)soundId, (Object)player.getName().getString());
    }

    public static void stopLoopingSound(Player player, String soundId) {
        String key = player.getId() + "_" + soundId;
        PlayerLoopingSound sound = activeSounds.remove(key);
        if (sound != null) {
            sound.stopSound();
            ArsAffinity.LOGGER.debug("Stopped looping sound {} for player {}", (Object)soundId, (Object)player.getName().getString());
        }
    }

    public static void stopAllSounds(Player player) {
        activeSounds.entrySet().removeIf(entry -> {
            if (((String)entry.getKey()).startsWith(player.getId() + "_")) {
                ((PlayerLoopingSound)((Object)((Object)entry.getValue()))).stopSound();
                return true;
            }
            return false;
        });
    }

    private static SoundEvent getSoundEvent(String soundId) {
        return switch (soundId) {
            case "curse_field" -> (SoundEvent)ModSounds.CURSE_FIELD.get();
            case "sanctuary" -> (SoundEvent)ModSounds.SANCTUARY.get();
            default -> null;
        };
    }

    private static class PlayerLoopingSound
    extends AbstractTickableSoundInstance {
        private final Player player;
        private boolean stopped = false;

        public PlayerLoopingSound(Player player, SoundEvent soundEvent) {
            super(soundEvent, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
            this.player = player;
            this.looping = true;
            this.delay = 0;
            this.volume = 0.5f;
            this.pitch = 1.0f;
            this.attenuation = SoundInstance.Attenuation.LINEAR;
            this.updatePosition();
        }

        public void tick() {
            if (this.stopped || !this.player.isAlive()) {
                this.stopSound();
                return;
            }
            this.updatePosition();
        }

        private void updatePosition() {
            this.x = this.player.getX();
            this.y = this.player.getY();
            this.z = this.player.getZ();
        }

        public boolean canStartSilent() {
            return true;
        }

        public void stopSound() {
            this.stopped = true;
            this.looping = false;
            this.volume = 0.0f;
        }
    }
}

