/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability;

import com.github.ars_affinity.perk.AffinityPerk;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractDashAbility {
    public final void executeAbility(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        double requiredMana;
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        if (manaCap == null) {
            return;
        }
        double currentMana = manaCap.getCurrentMana();
        if (currentMana < (requiredMana = this.getRequiredManaCost(perk, manaCap))) {
            return;
        }
        if (this.isPlayerOnCooldown((Player)player)) {
            return;
        }
        this.applyCooldown((Player)player, perk.cooldown);
        float dashLength = this.getDashLength(perk);
        float dashDuration = this.getDashDuration(perk);
        this.performDash(player, dashLength, dashDuration, this.getDashSpeedMultiplier());
        this.targetEntitiesInDashPath(player, dashLength, (living, idx, start, end, dir) -> this.onHitTarget(player, living, start, end, dir, idx));
        this.spawnParticles(player, dashLength);
        this.playSounds(player);
        this.consumeMana(player, perk, manaCap);
    }

    protected double getRequiredManaCost(AffinityPerk.ActiveAbilityPerk perk, IManaCap manaCap) {
        return perk.manaCost;
    }

    protected float getDashLength(AffinityPerk.ActiveAbilityPerk perk) {
        return perk.dashLength;
    }

    protected float getDashDuration(AffinityPerk.ActiveAbilityPerk perk) {
        return perk.dashDuration;
    }

    protected double getDashSpeedMultiplier() {
        return 1.0;
    }

    protected boolean isPlayerOnCooldown(Player player) {
        Holder<MobEffect> effect = this.getCooldownEffect();
        return effect != null && player.hasEffect(effect);
    }

    protected void applyCooldown(Player player, int cooldownTicks) {
        Holder<MobEffect> effect = this.getCooldownEffect();
        if (effect != null) {
            player.addEffect(new MobEffectInstance(effect, cooldownTicks, 0, false, true, true));
        }
    }

    private void performDash(ServerPlayer player, float dashLength, float dashDuration, double speedMultiplier) {
        Vec3 lookDirection = player.getLookAngle();
        double dashSpeed = (double)(dashLength / dashDuration) * speedMultiplier;
        Vec3 dashVelocity = lookDirection.scale(dashSpeed);
        player.setDeltaMovement(dashVelocity);
        player.hurtMarked = true;
        MinecraftServer server = player.level().getServer();
        if (server != null) {
            server.tell((Runnable)new TickTask((int)((float)server.getTickCount() + dashDuration * 20.0f), () -> {
                if (player.isAlive()) {
                    Vec3 currentVel = player.getDeltaMovement();
                    Vec3 horizontalVel = new Vec3(currentVel.x, currentVel.y, currentVel.z);
                    if (horizontalVel.lengthSqr() > 0.01) {
                        player.setDeltaMovement(horizontalVel.scale(0.1));
                    }
                }
            }));
        }
    }

    private void targetEntitiesInDashPath(ServerPlayer player, float dashLength, TargetConsumer consumer) {
        Vec3 startPos = player.position();
        Vec3 lookDirection = player.getLookAngle();
        Vec3 endPos = startPos.add(lookDirection.scale((double)dashLength));
        double radius = 3.0;
        AABB queryBox = new AABB(Math.min(startPos.x, endPos.x), Math.min(startPos.y, endPos.y), Math.min(startPos.z, endPos.z), Math.max(startPos.x, endPos.x), Math.max(startPos.y, endPos.y), Math.max(startPos.z, endPos.z)).inflate(radius + 0.5);
        List candidates = player.level().getEntities((Entity)player, queryBox, entity -> entity instanceof LivingEntity && entity != player && !entity.isAlliedTo((Entity)player));
        int index = 0;
        for (Entity entity2 : candidates) {
            LivingEntity livingEntity;
            if (!(entity2 instanceof LivingEntity) || !this.isEntityWithinCapsule(livingEntity = (LivingEntity)entity2, startPos, endPos, radius)) continue;
            consumer.accept(livingEntity, index, startPos, endPos, lookDirection);
            ++index;
        }
    }

    private boolean isEntityWithinCapsule(LivingEntity entity, Vec3 start, Vec3 end, double radius) {
        Vec3 center = entity.getBoundingBox().getCenter();
        double effectiveRadius = radius + (double)entity.getBbWidth() * 0.5;
        double distance = this.distancePointToSegment(center, start, end);
        return distance <= effectiveRadius;
    }

    private double distancePointToSegment(Vec3 point, Vec3 a, Vec3 b) {
        Vec3 ab = b.subtract(a);
        Vec3 ap = point.subtract(a);
        double abLenSqr = ab.lengthSqr();
        if (abLenSqr <= 1.0E-7) {
            return point.distanceTo(a);
        }
        double t = ap.dot(ab) / abLenSqr;
        t = Mth.clamp((double)t, (double)0.0, (double)1.0);
        Vec3 closest = a.add(ab.scale(t));
        return point.distanceTo(closest);
    }

    protected void scheduleTask(ServerPlayer player, int delayTicks, Runnable task) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        server.tell((Runnable)new TickTask(server.getTickCount() + delayTicks, task));
    }

    protected Vec3 computeSideOffset(Vec3 startPos, Vec3 endPos, Vec3 dashDir, LivingEntity target, int index) {
        Vec3 segment = endPos.subtract(startPos);
        double lenSqr = segment.lengthSqr();
        double t = 0.0;
        if (lenSqr > 1.0E-7) {
            t = Mth.clamp((double)(target.getBoundingBox().getCenter().subtract(startPos).dot(segment) / lenSqr), (double)0.0, (double)1.0);
        }
        Vec3 base = startPos.add(segment.scale(t));
        Vec3 lateral = dashDir.cross(new Vec3(0.0, 1.0, 0.0));
        if (lateral.lengthSqr() < 1.0E-6) {
            lateral = dashDir.cross(new Vec3(1.0, 0.0, 0.0));
        }
        lateral = lateral.normalize().scale(((index & 1) == 0 ? 1.0 : -1.0) * 0.5);
        return base.add(lateral).add(dashDir.normalize().scale(0.25));
    }

    protected void spawnParticles(ServerPlayer player, float dashLength) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 playerPos = player.position();
        Vec3 lookDirection = player.getLookAngle();
        int count = this.getTrailParticleCount();
        for (int i = 0; i < count; ++i) {
            double progress = (double)i / (double)count;
            Vec3 p = playerPos.add(lookDirection.scale((double)dashLength * progress));
            this.spawnTrailParticle(serverLevel, p.x, p.y, p.z);
        }
        this.spawnBurstParticles(serverLevel, playerPos.x, playerPos.y, playerPos.z);
    }

    protected int getTrailParticleCount() {
        return 30;
    }

    protected abstract void spawnTrailParticle(ServerLevel var1, double var2, double var4, double var6);

    protected abstract void spawnBurstParticles(ServerLevel var1, double var2, double var4, double var6);

    protected abstract void playSounds(ServerPlayer var1);

    protected abstract Holder<MobEffect> getCooldownEffect();

    protected abstract void onHitTarget(ServerPlayer var1, LivingEntity var2, Vec3 var3, Vec3 var4, Vec3 var5, int var6);

    protected void consumeMana(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk, IManaCap manaCap) {
        manaCap.removeMana((double)((int)perk.manaCost));
    }

    @FunctionalInterface
    private static interface TargetConsumer {
        public void accept(LivingEntity var1, int var2, Vec3 var3, Vec3 var4, Vec3 var5);
    }
}

