/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.network;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.client.sound.LoopingSoundManager;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class LoopingSoundPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<LoopingSoundPacket> TYPE = new CustomPacketPayload.Type(ArsAffinity.prefix("looping_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LoopingSoundPacket> CODEC = StreamCodec.ofMember(LoopingSoundPacket::toBytes, LoopingSoundPacket::new);
    private final int playerId;
    private final String soundId;
    private final boolean start;

    public LoopingSoundPacket(int playerId, String soundId, boolean start) {
        this.playerId = playerId;
        this.soundId = soundId;
        this.start = start;
    }

    public LoopingSoundPacket(RegistryFriendlyByteBuf buf) {
        this.playerId = buf.readVarInt();
        this.soundId = buf.readUtf();
        this.start = buf.readBoolean();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.playerId);
        buf.writeUtf(this.soundId);
        buf.writeBoolean(this.start);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        Handle.handle(this, minecraft, player);
    }

    private static class Handle {
        private Handle() {
        }

        public static void handle(LoopingSoundPacket packet, Minecraft minecraft, Player player) {
            if (minecraft.level != null && minecraft.level.isClientSide()) {
                Player p;
                Player targetPlayer;
                Entity entity = minecraft.level.getEntity(packet.playerId);
                Player player2 = targetPlayer = entity instanceof Player ? (p = (Player)entity) : null;
                if (targetPlayer != null) {
                    if (packet.start) {
                        LoopingSoundManager.startLoopingSound(targetPlayer, packet.soundId);
                    } else {
                        LoopingSoundManager.stopLoopingSound(targetPlayer, packet.soundId);
                    }
                }
            }
        }
    }
}

