/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.registry.ModPotions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public class DeflectionEvents {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        Level level = projectile.level();
        if (level.isClientSide()) {
            return;
        }
        HitResult rayTraceResult = event.getRayTraceResult();
        if (!(rayTraceResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
        Entity hitEntity = entityHitResult.getEntity();
        if (!(hitEntity instanceof Player)) {
            return;
        }
        Player player = (Player)hitEntity;
        if (player.hasEffect(ModPotions.DEFLECTION_COOLDOWN_EFFECT)) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_DEFLECTION)) {
            int time = AffinityPerkHelper.getPerkTime(player, AffinityPerkType.PASSIVE_DEFLECTION);
            event.setCanceled(true);
            try {
                Vec3 motion = projectile.getDeltaMovement();
                Vec3 reversedMotion = motion.scale(-1.0);
                projectile.setDeltaMovement(reversedMotion);
                double x = reversedMotion.x;
                double z = reversedMotion.z;
                if (x != 0.0 || z != 0.0) {
                    projectile.setYRot((float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f);
                }
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)projectile;
                    arrow.setBaseDamage(arrow.getBaseDamage() * 1.5);
                }
                if (projectile instanceof Entity) {
                    Projectile entity = projectile;
                    ClientboundSetEntityMotionPacket motionPacket = new ClientboundSetEntityMotionPacket((Entity)entity);
                    level.getServer().getPlayerList().broadcast(null, entity.getX(), entity.getY(), entity.getZ(), 64.0, level.dimension(), (Packet)motionPacket);
                }
                player.addEffect(new MobEffectInstance(ModPotions.DEFLECTION_COOLDOWN_EFFECT, time, 0, false, true, true));
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("Deflection: Error reversing projectile", (Throwable)e);
            }
        }
    }
}

