/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonDecoy;
import net.minecraft.server.TickTask;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class GhostStepEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        ArsAffinity.LOGGER.debug("Ghost Step: Player {} is dying, checking for Ghost Step perk", (Object)player.getName().getString());
        if (player.hasEffect(ModPotions.GHOST_STEP_COOLDOWN_EFFECT)) {
            ArsAffinity.LOGGER.debug("Ghost Step: Player {} has cooldown, skipping", (Object)player.getName().getString());
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_GHOST_STEP)) {
            event.setCanceled(true);
            ArsAffinity.LOGGER.debug("Ghost Step: Player {} has Ghost Step perk, activating", (Object)player.getName().getString());
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_GHOST_STEP);
            int time = AffinityPerkHelper.getPerkTime(player, AffinityPerkType.PASSIVE_GHOST_STEP);
            int cooldown = AffinityPerkHelper.getPerkCooldown(player, AffinityPerkType.PASSIVE_GHOST_STEP);
            float maxHealth = player.getMaxHealth();
            float healAmount = maxHealth * amount;
            ArsAffinity.LOGGER.debug("Ghost Step: Setting health to {} (was {}), canceling event", (Object)Float.valueOf(healAmount), (Object)Float.valueOf(player.getHealth()));
            player.setHealth(healAmount);
            ArsAffinity.LOGGER.debug("Ghost Step: Event canceled: {}, player health: {}", (Object)event.isCanceled(), (Object)Float.valueOf(player.getHealth()));
            GhostStepEvents.castDecoyEffect(player, time);
            GhostStepEvents.removeStuckProjectiles(player);
            GhostStepEvents.scheduleDelayedProjectileRemoval(player);
            player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, time));
            player.addEffect(new MobEffectInstance(ModPotions.GHOST_STEP_COOLDOWN_EFFECT, cooldown, 0, false, true, true));
            ArsAffinity.LOGGER.debug("Player {} activated Ghost Step - healed for {} health, invisible for {} seconds", (Object)player.getName().getString(), (Object)Float.valueOf(healAmount), (Object)time);
        } else {
            ArsAffinity.LOGGER.debug("Ghost Step: Player {} does not have Ghost Step perk", (Object)player.getName().getString());
        }
    }

    private static void removeStuckProjectiles(Player player) {
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        player.setArrowCount(0);
    }

    private static void scheduleDelayedProjectileRemoval(Player player) {
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        level.getServer().tell((Runnable)new TickTask(level.getServer().getTickCount() + 1, () -> {
            if (player.isAlive() && !player.level().isClientSide()) {
                GhostStepEvents.removeStuckProjectiles(player);
            }
        }));
    }

    private static void castDecoyEffect(Player player, int durationSeconds) {
        try {
            Level level = player.level();
            SpellStats spellStats = new SpellStats.Builder().addDurationModifier((double)durationSeconds / 30.0).build();
            Spell emptySpell = new Spell();
            SpellContext spellContext = new SpellContext(level, emptySpell, (LivingEntity)player, (IWrappedCaster)new LivingCaster((LivingEntity)player));
            EntityHitResult hitResult = new EntityHitResult((Entity)player);
            EffectSummonDecoy.INSTANCE.onResolve((HitResult)hitResult, level, (LivingEntity)player, spellStats, spellContext, null);
            ArsAffinity.LOGGER.debug("Player {} cast Decoy effect for {} seconds", (Object)player.getName().getString(), (Object)durationSeconds);
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Ghost Step: Error casting decoy effect", (Throwable)e);
        }
    }
}

