/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class PassiveManaTapEvents {
    @SubscribeEvent
    public static void onSpellDamage(SpellDamageEvent.Post event) {
        LivingEntity livingEntity = event.caster;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (event.damage <= 0.0f) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_MANA_TAP)) {
            double maxMana;
            double currentMana;
            double newMana;
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_MANA_TAP);
            double manaRestore = event.damage * amount;
            ManaCap playerMana = CapabilityRegistry.getMana((LivingEntity)player);
            if (playerMana != null && (newMana = Math.min((currentMana = playerMana.getCurrentMana()) + manaRestore, maxMana = (double)playerMana.getMaxMana())) > currentMana) {
                playerMana.setMana(newMana);
                ArsAffinity.LOGGER.debug("Player {} dealt {} damage - PASSIVE_MANA_TAP restored {} mana ({}%)", (Object)player.getName().getString(), (Object)Float.valueOf(event.damage), (Object)manaRestore, (Object)((int)(amount * 100.0f)));
            }
        }
    }
}

