/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class PassiveStoneSkinEvents {
    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (!event.getSource().is(DamageTypeTags.IS_PLAYER_ATTACK) && !event.getSource().is(DamageTypes.MOB_ATTACK)) {
            return;
        }
        if (player.hasEffect(ModPotions.STONE_SKIN_COOLDOWN_EFFECT)) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_STONE_SKIN)) {
            Level manaCap;
            int time = AffinityPerkHelper.getPerkTime(player, AffinityPerkType.PASSIVE_STONE_SKIN);
            event.setCanceled(true);
            player.addEffect(new MobEffectInstance(ModPotions.STONE_SKIN_COOLDOWN_EFFECT, time, 0, false, true, true));
            Vec3 pos = player.position();
            player.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 0.9f);
            DamageSource damageSource = event.getSource();
            Entity attackerEntity = damageSource.getEntity();
            if (attackerEntity == null) {
                attackerEntity = damageSource.getDirectEntity();
            }
            if (attackerEntity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)attackerEntity;
                manaCap = CapabilityRegistry.getMana((LivingEntity)player);
                double currentMana = manaCap != null ? manaCap.getCurrentMana() : 0.0;
                double strength = Math.sqrt(Math.max(currentMana, 0.0) / 100.0);
                double dx = attacker.getX() - player.getX();
                double dz = attacker.getZ() - player.getZ();
                double dist = Math.max(Math.sqrt(dx * dx + dz * dz), 0.01);
                attacker.knockback(strength, -dx / dist, -dz / dist);
            }
            if ((manaCap = player.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)manaCap;
                BlockParticleOption stoneParticles = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState());
                for (int i = 0; i < 12; ++i) {
                    double ox = (Math.random() - 0.5) * 3.0;
                    double oy = Math.random() * 1.0;
                    double oz = (Math.random() - 0.5) * 3.0;
                    serverLevel.sendParticles((ParticleOptions)stoneParticles, player.getX() + ox, player.getY() + oy, player.getZ() + oz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

